﻿using System;
using System.ComponentModel;
using System.Windows.Threading;

namespace Zegar.ModelWidoku
{
    class Zegar : INotifyPropertyChanged
    {
        private DateTime poprzedniCzas = DateTime.Now;

        public DateTime AktualnyCzas
        {
            get
            {
                return DateTime.Now;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if (poprzedniCzas.Second == AktualnyCzas.Second) return;

            if (PropertyChanged != null)
                PropertyChanged(
                    this,
                    new PropertyChangedEventArgs(nameof(AktualnyCzas)));

            poprzedniCzas = AktualnyCzas;
        }

        public Zegar()
        {
            DispatcherTimer timerOdświeżaniaWidoku = new DispatcherTimer();
            timerOdświeżaniaWidoku.Interval = TimeSpan.FromMilliseconds(250);
            timerOdświeżaniaWidoku.Tick += (sender, e) => { onPropertyChanged(); };
            if(!DesignerProperties.GetIsInDesignMode(new System.Windows.DependencyObject())) timerOdświeżaniaWidoku.Start();
        }
    }
}
