﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;

namespace Zegar
{
    public enum Wskazówka { Godzinowa, Minutowa, Sekundowa }

    class KonwerterKątaWskazówki : IValueConverter
    {
        public Wskazówka Wskazówka { get; set; } = Wskazówka.Godzinowa;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            DateTime dt = (DateTime)value;
            double kąt = 0;
            switch (Wskazówka)
            {
                case Wskazówka.Godzinowa:
                    kąt = dt.Hour;
                    if (dt.Hour > 12) kąt -= 12;
                    kąt += dt.Minute / 60.0;
                    kąt /= 12.0;
                    break;
                case Wskazówka.Minutowa:
                    kąt = dt.Minute;
                    kąt += dt.Second / 60.0;
                    kąt /= 60.0;
                    break;
                case Wskazówka.Sekundowa:
                    kąt = dt.Second;                    
                    kąt /= 60.0;
                    break;
            }
            kąt *= 360;
            return kąt;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
