﻿using System.ComponentModel;
using System.Windows.Input;

namespace RównaniaKwadratowe2.ModelWidoku
{
    public class ModelWidokuRównańKwadratowych : INotifyPropertyChanged
    {
        private WspółczynnikiRównaniaKwadratowego współczynniki = new WspółczynnikiRównaniaKwadratowego() { A = 1, B = -2, C = 1 };
        private RozwiązywaczRównańKwadratowych model = new RozwiązywaczRównańKwadratowych();

        public double X1
        {
            get
            {
                return model.X1;
            }
        }

        public double X2
        {
            get
            {
                return model.X2;
            }
        }

        public double A
        {
            set
            {
                bool czyWcześniejIstniałyRozwiązania = współczynniki.CzyIstniejąRozwiązania;
                współczynniki.A = value;
                bool czyTerazIstniejąRozwiązania = współczynniki.CzyIstniejąRozwiązania;
                if (czyTerazIstniejąRozwiązania != czyWcześniejIstniałyRozwiązania)
                    (Rozwiąż as RelayCommand).RaiseCanExecuteChangedEvent();
            }
            get
            {
                return współczynniki.A;
            }
        }

        public double B
        {
            set
            {
                bool czyWcześniejIstniałyRozwiązania = współczynniki.CzyIstniejąRozwiązania;
                współczynniki.B = value;
                bool czyTerazIstniejąRozwiązania = współczynniki.CzyIstniejąRozwiązania;
                if (czyTerazIstniejąRozwiązania != czyWcześniejIstniałyRozwiązania)
                    (Rozwiąż as RelayCommand).RaiseCanExecuteChangedEvent();
            }
            get
            {
                return współczynniki.B;
            }
        }

        public double C
        {
            set
            {
                bool czyWcześniejIstniałyRozwiązania = współczynniki.CzyIstniejąRozwiązania;
                współczynniki.C = value;
                bool czyTerazIstniejąRozwiązania = współczynniki.CzyIstniejąRozwiązania;
                if (czyTerazIstniejąRozwiązania != czyWcześniejIstniałyRozwiązania)
                    (Rozwiąż as RelayCommand).RaiseCanExecuteChangedEvent();
            }
            get
            {
                return współczynniki.C;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if(PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X1)));
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X2)));
            }
        }

        /*
        public ModelWidokuRównańKwadratowych()
        {
            rozwiąż = new RozwiążCommand(model);
            rozwiąż.Executed += (object sender, System.EventArgs e) => { onPropertyChanged(); };
        }
        */

        private ICommand rozwiąż = null;

        public ICommand Rozwiąż
        {
            get
            {
                if(rozwiąż == null)
                {
                    rozwiąż = new RelayCommand(
                        (object parameter) => 
                        {
                            model.Rozwiąż(współczynniki);
                            onPropertyChanged();
                        },
                        (object parameter) => { return współczynniki.CzyIstniejąRozwiązania; }
                        );
                }
                return rozwiąż;
            }
        }
    }
}
