﻿using System;
using System.Globalization;
using Windows.UI.Xaml.Data;

namespace RównaniaKwadratoweUWP
{
    public class DoubleToStringConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            double wartość = (double)value;
            return wartość.ToString(new CultureInfo(language));
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            try
            {
                string łańcuch = (string)value;
                if (string.IsNullOrEmpty(łańcuch)) return 0;
                else return double.Parse(łańcuch, new CultureInfo(language));
            }
            catch
            {
                return 0;
            }
        }
    }
}
