﻿using Microsoft.Xaml.Behaviors;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Media;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace DrugaAplikacjaMvvm1
{
    public class UaktywnijPoleTekstowe : Behavior<TextBox>
    {
        protected override void OnAttached()
        {
            this.AssociatedObject.Focus();
        }
    }

    public class EmitujDźwiękPrzyNaciskaniuKlawiszy : Behavior<TextBox>
    {
        SoundPlayer sp;

        protected override void OnAttached()
        {
            TextBox textBox = this.AssociatedObject;
            textBox.TextChanged += textBox_TextChanged;
            sp = new SoundPlayer("typewriter.wav");
        }

        private void textBox_TextChanged(object sender, TextChangedEventArgs e)
        {
            sp.Play();
        }
    }

    public class ZamknijOknoPoNaciśnięciuKlawisza : Behavior<Window>
    {
        public Key Klawisz { get; set; } = Key.None;

        protected override void OnAttached()
        {
            this.AssociatedObject.PreviewKeyDown += window_PreviewKeyDown;
        }

        private void window_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Klawisz) this.AssociatedObject.Close();
        }
    }

    /*
    //to nie może się udać
    public class PrzyciskZamykającyOkno : Behavior<Window>
    {
        private Button przycisk;

        public Button Przycisk
        {
            get
            {
                return przycisk;
            }
            set
            {
                przycisk = value;
                if(przycisk != null)
                    przycisk.Click +=
                        (object sender, RoutedEventArgs e) =>
                        {
                            this.AssociatedObject.Close();
                        };
            }
        }

        //protected override void OnAttached() //nie potrzebuję
    }
    */

    public class PrzyciskZamykającyOkno : Behavior<Window>
    {
        private static DependencyProperty PrzyciskProperty = DependencyProperty.Register(
            nameof(Przycisk),
            typeof(Button),
            typeof(PrzyciskZamykającyOkno),
            new PropertyMetadata(null, zmianaPrzycisku));

        private static void zmianaPrzycisku(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            Window window = (d as PrzyciskZamykającyOkno).AssociatedObject;

            void przyciskZamykającyOkno_Click(object sender, RoutedEventArgs _e)
            {
                window.Close();
            }

            if (e.OldValue != null) (e.OldValue as Button).Click -= przyciskZamykającyOkno_Click;
            if (e.NewValue != null) (e.NewValue as Button).Click += przyciskZamykającyOkno_Click;            
        }

        public Button Przycisk
        {
            get
            {
                return (Button)GetValue(PrzyciskProperty);
            }
            set
            {
                SetValue(PrzyciskProperty, value);                
            }
        }
    }

    public static class KlawiszZmieniającyKolorTłaBehavior //zachowanie doczepione
    {
        //własność Key Klawisz
        public static Key GetKlawisz(DependencyObject d)
        {
            return (Key)d.GetValue(klawiszProperty);
        }

        public static void SetKlawisz(DependencyObject d, Key klawisz)
        {
            d.SetValue(klawiszProperty, klawisz);
        }

        private static DependencyProperty klawiszProperty =
            DependencyProperty.RegisterAttached(
                "Klawisz",
                typeof(Key),
                typeof(KlawiszZmieniającyKolorTłaBehavior),
                new PropertyMetadata(Key.None, klawiszZmieniony));

        private static void klawiszZmieniony(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            //Key klawisz = (Key)d.GetValue(klawiszProperty);
            Key klawisz = GetKlawisz(d);
            if (d is Control)
            {
                Control c = d as Control;
                c.PreviewKeyDown +=
                    (object sender, KeyEventArgs _e) =>
                    {
                        if (_e.Key == klawisz)
                            c.Background = System.Windows.Media.Brushes.Red;
                    };
            }
        }
    }
}
