﻿using System.ComponentModel;

namespace PierwszaAplikacjaMvvm1.ModelWidoku
{
    using Model;
    using System.Windows.Input;

    public class ModelWidokuPAM : INotifyPropertyChanged
    {
        private ModelPAM model = PlikHelper.CzytajModel();

        public byte Wartość
        {
            get
            {
                return model.Wartość;
            }
            set
            {
                model.Wartość = value;
                //PlikHelper.Zapisz(model); //bardzo nie optymalne!!!
                model.Zapisz(); //nadal bardzo nie optymalne!!!
                onPropertyChanged();
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(Wartość)));
        }

        private ICommand resetuj;

        public ICommand Resetuj
        {
            get
            {
                if (resetuj == null) resetuj = new RelayCommand(
                     (object p) =>
                     {
                         model.Resetuj();
                         onPropertyChanged();
                     },
                     (object p) =>
                     {
                         return Wartość > 0;
                     });
                return resetuj;
            }
        }
    }
}
