﻿using System;
using System.Globalization;
using System.Windows.Data;

namespace RównaniaKwadratowe2
{
    public class DoubleToStringConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            double wartość = (double)value;
            return wartość.ToString(culture);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string łańcuch = (string)value;
            if (string.IsNullOrEmpty(łańcuch)) return 0;
            else return double.Parse(łańcuch, culture);
        }
    }

    public class KonwerterWspółczynnikówRównaniaKwadratowego : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            try
            {
                double a = double.Parse((string)values[0], culture);
                double b = double.Parse((string)values[1], culture);
                double c = double.Parse((string)values[2], culture);
                return new WspółczynnikiRównaniaKwadratowego() { A = a, B = b, C = c };
            }
            catch
            {
                return new WspółczynnikiRównaniaKwadratowego() { A = 0, B = 0, C = 0 };
            }
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
