﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace DragAndDrop
{
    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private const string formatLista = "Format_Lista";
        private const string formatElement = "Format_Element";

        private Point? początkowaPozycja = null;

        private void ListBox_PreviewMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            początkowaPozycja = e.GetPosition(this);
        }

        private const int minimumDragDistance = 15;

        private void ListBox_MouseMove(object sender, MouseEventArgs e)
        {
            if (!początkowaPozycja.HasValue) return;

            Point bieżącaPozycja = e.GetPosition(this);
            Vector przesunięcie = bieżącaPozycja - początkowaPozycja.Value;

            if (przesunięcie.X > minimumDragDistance || przesunięcie.Y > minimumDragDistance)
            {
                początkowaPozycja = null;

                ListBox lbSender = sender as ListBox;

                //ListBoxItem element = lbSender.GetItemAt(e.GetPosition(lbSender));
                string etykietyPrzenoszonychElementów = "";
                foreach (object element in lbSender.SelectedItems)
                    etykietyPrzenoszonychElementów += (element as ListBoxItem).Content as string + "\n";
                //if (element == null) return;
                if (string.IsNullOrWhiteSpace(etykietyPrzenoszonychElementów)) return;

                DataObject dane = new DataObject();
                //dane.SetData(formatLista, lbSender);
                //dane.SetData(formatElement, element);           
                //dane.SetData(DataFormats.Text, element.Content as string);
                dane.SetData(DataFormats.Text, etykietyPrzenoszonychElementów);

                DragDrop.DoDragDrop(lbSender, dane, DragDropEffects.Move | DragDropEffects.Copy);
            }
        }

        private void ListBox_DragEnter(object sender, DragEventArgs e)
        {
            if (e.KeyStates.HasFlag(DragDropKeyStates.ControlKey))
                e.Effects = DragDropEffects.Copy;
            else e.Effects = DragDropEffects.Move;
        }

        private void ListBox_Drop(object sender, DragEventArgs e)
        {
            ListBox lbSender = sender as ListBox;

            //ListBox lbŹródło = e.Data.GetData(formatLista) as ListBox;
            //ListBoxItem element = e.Data.GetData(formatElement) as ListBoxItem;
            //ListBoxItem element = new ListBoxItem() { Content = e.Data.GetData(DataFormats.Text) };            

            string[] etykietyElmentów = (e.Data.GetData(DataFormats.Text) as string).Replace("\r","").Split('\n');

            //if (e.KeyStates.HasFlag(DragDropKeyStates.ControlKey))
            //{
            //    element = new ListBoxItem() { Content = element.Content };
            //}
            //else lbŹródło.Items.Remove(element);
            foreach(string etykieta in etykietyElmentów)
            {
                ListBoxItem element = new ListBoxItem() { Content = etykieta };
                lbSender.Items.Add(element);
            }
            
        }
    }
}
