﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace KolekcjeWPF.ModelWidoku
{
    public class Zadanie : INotifyPropertyChanged
    {
        private Model.Zadanie model;        

        public string Opis
        {
            get
            {
                return model.Opis;
            }
        }

        public DateTime PlanowanyTerminRealizacji
        {
            get
            {
                return model.PlanowanaDataRealizacji;
            }
        }

        public Model.PriorytetZadania Priorytet
        {
            get
            {
                return model.Priorytet;
            }
        }

        public bool CzyZrealizowane
        {
            get
            {
                return model.CzyZrealizowane;
            }
            set
            {
                model.CzyZrealizowane = value;
            }
        }

        public bool CzyZadaniePozostajeNiezrealizowanePoUpłynieciuPlanowanegoTerminuRealizacji
        {
            get
            {
                return !CzyZrealizowane && (DateTime.Now > PlanowanyTerminRealizacji);
            }
        }

        public Zadanie(Model.Zadanie model)
        {
            this.model = model;
        }

        public Model.Zadanie GetModel()
        {
            return model;
        }

        public Zadanie(
            string opis, DateTime dataRealizacji, DateTime dataUtworzenia, 
            Model.PriorytetZadania priorytet, bool czyZrealizowane)
            :this(new Model.Zadanie(opis, dataRealizacji, dataUtworzenia, priorytet, czyZrealizowane))
        {}

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(params string[] nazwyWłasności)
        {
            if(PropertyChanged != null)
            {
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }

        public override string ToString()
        {
            return model.ToString();
        }

        private ICommand oznaczJakoZrealizowane = null;

        public ICommand OznaczJakoZrealizowane
        {
            get
            {
                if (oznaczJakoZrealizowane == null)
                    oznaczJakoZrealizowane = new RelayCommand(
                        (object p) => { model.CzyZrealizowane = true; onPropertyChanged(nameof(CzyZrealizowane)); },
                        (object p) => { return !model.CzyZrealizowane; }
                        );
                return oznaczJakoZrealizowane;
            }
        }

        private ICommand oznaczJakoNiezrealizowane = null;

        public ICommand OznaczJakoNiezrealizowane
        {
            get
            {
                if (oznaczJakoNiezrealizowane == null)
                    oznaczJakoNiezrealizowane = new RelayCommand(
                        (object p) => { model.CzyZrealizowane = false; onPropertyChanged(nameof(CzyZrealizowane)); },
                        (object p) => { return model.CzyZrealizowane; }
                        );
                return oznaczJakoNiezrealizowane;
            }
        }
    }
}
