﻿using System;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.Effects;

namespace ZegarWPF
{
    class Efekt : ShaderEffect
    {
        private static Uri getEffectResourceUri(string effectFileName)
        {
            string assemblyShortName = typeof(Efekt).Assembly.ToString().Split(',')[0];
            string uriString = "pack://application:,,,/" + assemblyShortName +
                ";component/" + effectFileName;
            return new Uri(uriString);
        }

        private static PixelShader pixelShader = new PixelShader()
        {
            UriSource = getEffectResourceUri("Efekt.ps")
        };

        public Efekt()
        {
            this.PixelShader = pixelShader;

            UpdateShaderValue(KolorProperty);
            UpdateShaderValue(InputProperty);
        }

        public static readonly DependencyProperty KolorProperty =
            DependencyProperty.Register("Kolor", typeof(Color), typeof(Efekt),
                new UIPropertyMetadata(Colors.White, PixelShaderConstantCallback(0)));

        public Color Kolor
        {
            get { return (Color)GetValue(KolorProperty); }
            set { SetValue(KolorProperty, value); }
        }

        public Brush Input
        {
            get { return (Brush)GetValue(InputProperty); }
            set { SetValue(InputProperty, value); }
        }

        public static readonly DependencyProperty InputProperty =
            RegisterPixelShaderSamplerProperty("Input", typeof(Efekt), 0);

        public float Czas
        {
            get { return (float)GetValue(CzasProperty); }
            set
            {
                SetValue(CzasProperty, value);
                UpdateShaderValue(KolorProperty);
            }
        }

        public static readonly DependencyProperty CzasProperty =
            DependencyProperty.Register("Czas", typeof(float), typeof(Efekt),
                new UIPropertyMetadata(0f, PixelShaderConstantCallback(1)));
    }
}
