﻿using System;
using System.ComponentModel;
using System.Windows.Threading;

namespace ZegarWPF.ModelWidok
{
    public class Zegar : INotifyPropertyChanged
    {
        private DateTime poprzedniCzas = DateTime.Now;

        public DateTime AktualnyCzas
        {
            get
            {
                return DateTime.Now;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if (AktualnyCzas - poprzedniCzas < TimeSpan.FromSeconds(1) &&
               AktualnyCzas.Second == poprzedniCzas.Second) return;

            if (PropertyChanged != null) PropertyChanged(this, new PropertyChangedEventArgs(nameof(AktualnyCzas)));
        }

        private readonly bool isInDesignMode = DesignerProperties.GetIsInDesignMode(new System.Windows.DependencyObject());

        public Zegar()
        {
            DispatcherTimer timerOdświeżaniaWidoku = new DispatcherTimer();
            timerOdświeżaniaWidoku.Interval = TimeSpan.FromMilliseconds(250);
            timerOdświeżaniaWidoku.Tick +=
                (object sender, EventArgs e) =>
                {
                    onPropertyChanged();
                };
            if (!isInDesignMode) timerOdświeżaniaWidoku.Start();
        }
    }
}
