﻿using System;
using System.ComponentModel;
using System.Windows.Input;

namespace RównaniaKwadratowe.ModelWidoku
{
    using Biblioteka;

    public class ModelWidokuDlaRozwiązywaczaRównańKwadratowych : INotifyPropertyChanged
    {
        private RównaniaKwadratowe model = new RównaniaKwadratowe();

        public double X1
        {
            get
            {
                if (!model.OstatnieRozwiązanie.HasValue) return 0;
                else return model.OstatnieRozwiązanie.Value.X1;
            }
        }

        public double X2
        {
            get
            {
                if (!model.OstatnieRozwiązanie.HasValue) return 0;
                else return model.OstatnieRozwiązanie.Value.X2;
            }
        }

        double a = 1, b = -2, c = 1;

        public double A
        {
            get
            {
                return a;
            }
            set
            {
                bool czyWspółczynnikiByłyPoprawne = czyWspółczynnikiPoprawne();
                a = value;
                bool czyWspółczynnikiSąPoprawne = czyWspółczynnikiPoprawne();
                if (czyWspółczynnikiSąPoprawne != czyWspółczynnikiByłyPoprawne) (rozwiążCommand as RelayCommand).RaiseCanExecuteChangedEvent();
            }
        }

        public double B
        {
            get
            {
                return b;
            }
            set
            {
                bool czyWspółczynnikiByłyPoprawne = czyWspółczynnikiPoprawne();
                b = value;
                bool czyWspółczynnikiSąPoprawne = czyWspółczynnikiPoprawne();
                if (czyWspółczynnikiSąPoprawne != czyWspółczynnikiByłyPoprawne) (rozwiążCommand as RelayCommand).RaiseCanExecuteChangedEvent();
            }
        }

        public double C
        {
            get
            {
                return c;
            }
            set
            {
                bool czyWspółczynnikiByłyPoprawne = czyWspółczynnikiPoprawne();
                c = value;
                bool czyWspółczynnikiSąPoprawne = czyWspółczynnikiPoprawne();
                if (czyWspółczynnikiSąPoprawne != czyWspółczynnikiByłyPoprawne) (rozwiążCommand as RelayCommand).RaiseCanExecuteChangedEvent();
            }
        }

        private bool czyWspółczynnikiPoprawne()
        {
            return B * B - 4 * A * C >= 0;
        }

        private ICommand rozwiążCommand = null;        

        public ICommand Rozwiąż
        {
            get
            {
                if (rozwiążCommand == null)
                    rozwiążCommand = new RelayCommand(
                        (object parameter) =>
                        {
                            model.RozwiążRównanie(A, B, C);
                            onPropertyChanged();
                        },
                        (object parameter) =>
                        {
                            return czyWspółczynnikiPoprawne();
                        }
                        );
                return rozwiążCommand;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X1)));
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X2)));
            }
        }
    }
}
