﻿using System;
using System.ComponentModel;
using System.Windows.Input;

namespace RównaniaKwadratowe.ModelWidoku
{
    using Biblioteka;

    public class ModelWidokuDlaRozwiązywaczaRównańKwadratowych : INotifyPropertyChanged
    {
        private RównaniaKwadratowe model = new RównaniaKwadratowe();

        public double X1
        {
            get
            {
                if (!model.OstatnieRozwiązanie.HasValue) return 0;
                else return model.OstatnieRozwiązanie.Value.X1;
            }
        }

        public double X2
        {
            get
            {
                if (!model.OstatnieRozwiązanie.HasValue) return 0;
                else return model.OstatnieRozwiązanie.Value.X2;
            }
        }

        private ICommand rozwiążCommand = null;        

        /*
        public ICommand Rozwiąż
        {
            get
            {
                if (rozwiążCommand == null)
                {
                    PolecenieRozwiązywaniaRównań polecenie = new PolecenieRozwiązywaniaRównań(model);
                    polecenie.Executed += (object sender, EventArgs e) => { onPropertyChanged(); };
                    rozwiążCommand = polecenie;
                }
                return rozwiążCommand;
            }
        }
        */

        public ICommand Rozwiąż
        {
            get
            {
                if (rozwiążCommand == null)
                    rozwiążCommand = new RelayCommand(
                        (object parameter) =>
                        {
                            if (parameter is WspółczynnikiRównaniaKwadratowego)
                            {
                                WspółczynnikiRównaniaKwadratowego współczynniki = (WspółczynnikiRównaniaKwadratowego)parameter;
                                model.RozwiążRównanie(współczynniki.A, współczynniki.B, współczynniki.C);
                                onPropertyChanged();
                            }
                            else throw new ArgumentException("Niepoprawny typ parametru", nameof(parameter));
                        },
                        (object parameter) =>
                        {
                            if (parameter == null) return false;
                            if (parameter is WspółczynnikiRównaniaKwadratowego)
                            {
                                WspółczynnikiRównaniaKwadratowego współczynniki = (WspółczynnikiRównaniaKwadratowego)parameter;
                                return współczynniki.CzyWspółczynnikiPoprawne;
                            }
                            else throw new ArgumentException("Niepoprawny typ parametru", nameof(parameter));
                        }
                        );
                return rozwiążCommand;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X1)));
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X2)));
            }
        }
    }
}
