﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel;
using System.Windows.Input;

namespace PierwszaAplikacjaMvvm.ModelWidoku
{
    using Model;

    public class ModelWidokuPierwszejAplikacjiMvvm : INotifyPropertyChanged
    {
        //private ModelPierwszejAplikacjiMvvm model = new ModelPierwszejAplikacjiMvvm() { Wartość = 0 };
        private ModelPierwszejAplikacjiMvvm model = ModelPierwszejAplikacjiMvvm.Czytaj();

        public byte Wartość
        {
            get
            {
                return model.Wartość;
            }
            set
            {
                model.Wartość = value;
                model.Zapisz(); //bardzo nieoptymalne
                onPropertyChanged();
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected void onPropertyChanged()
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(Wartość)));
        }

        private ICommand resetuj;

        public ICommand Resetuj
        {
            get
            {
                if (resetuj == null) resetuj = new RelayCommand(
                    (object parameter) => 
                    {
                        model.Resetuj();
                        onPropertyChanged();
                    },
                    (object parameter) =>
                    {
                        return Wartość > 0;
                    });
                return resetuj;
            }
        }
    }
}
