﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel;
using System.Windows.Input;

namespace RównaniaKwadratowe.ModelWidoku
{
    using Biblioteka;

    public class ModelWidokuDlaRozwiązywaczaRównańKwadratowych : INotifyPropertyChanged
    {
        private RównaniaKwadratowe model = new RównaniaKwadratowe();

        public double X1
        {
            get
            {
                if (!model.OstatnieRozwiązanie.HasValue) return 0;
                else return model.OstatnieRozwiązanie.Value.X1;
            }
        }

        public double X2
        {
            get
            {
                if (!model.OstatnieRozwiązanie.HasValue) return 0;
                else return model.OstatnieRozwiązanie.Value.X2;
            }
        }

        private ICommand rozwiążCommand = null;        

        public ICommand Rozwiąż
        {
            get
            {
                if (rozwiążCommand == null)
                {
                    PolecenieRozwiązywaniaRównań polecenie = new PolecenieRozwiązywaniaRównań(model);
                    polecenie.Executed += (object sender, EventArgs e) => { onPropertyChanged(); };
                    rozwiążCommand = polecenie;
                }
                return rozwiążCommand;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X1)));
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X2)));
            }
        }
    }
}
