﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

public static class WinAPI
{
    private const uint WM_CLOSE = 16;
    private const uint WM_KEYDOWN = 0x0100;
    private const uint WM_KEYUP = 0x0101;
    private const uint WM_CHAR = 0x0102;
    private const uint WM_SYSKEYDOWN = 0x0104;
    private const uint WM_SYSKEYUP = 0x0105;

    [DllImport("user32.dll")]
    private static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, IntPtr wParam, IntPtr lParam);

    [DllImport("user32.dll")]
    [return: MarshalAs(UnmanagedType.Bool)]
    public static extern bool MessageBeep(uint rodzajDzwięku);

    [DllImport("user32.dll", EntryPoint = "MessageBox", CharSet = CharSet.Unicode)]
    public static extern int _MessageBox(IntPtr hWnd, string text, string caption, uint type);

    public enum StanOkna : uint { Ukryte = 0, Normalne, Zminimalizowane, Zmaksymalizowane, Nieaktywne, Domyślne = 10 };

    [DllImport("kernel32.dll")]
    //public static extern uint WinExec(string polecenie, uint stanOkna);
    public static extern uint WinExec(string polecenie, StanOkna stanOkna);

    [DllImport("kernel32.dll")]
    public static extern bool GetDiskFreeSpaceEx(
        string katalog,
        ref long wolneMiejsceDlaUżytkownika,
        ref long rozmiarDysku,
        ref long wolneMiejsceNaDysku);

    public const int MAX_PATH = 260;

    [DllImport("kernel32.dll")]
    public static extern uint GetWindowsDirectory(StringBuilder bufor, uint rozmiarBufora);

    [DllImport("user32.dll")]
    public static extern bool GetCursorPos(ref Point lpPoint);
    //Cursor.Position

    [DllImport("user32.dll")]
    public static extern bool GetPhysicalCursorPos(ref Point lpPoint);

    [DllImport("user32.dll")]
    public static extern bool SetProcessDPIAware();

    public enum TernaryRasterOperations : uint
    {
        SRCCOPY = 0x00CC0020,
        SRCPAINT = 0x00EE0086,
        SRCAND = 0x008800C6,
        SRCINVERT = 0x00660046,
        SRCERASE = 0x00440328,
        NOTSRCCOPY = 0x00330008,
        NOTSRCERASE = 0x001100A6,
        MERGECOPY = 0x00C000CA,
        MERGEPAINT = 0x00BB0226,
        PATCOPY = 0x00F00021,
        PATPAINT = 0x00FB0A09,
        PATINVERT = 0x005A0049,
        DSTINVERT = 0x00550009,
        BLACKNESS = 0x00000042,
        WHITENESS = 0x00FF0062,
        CAPTUREBLT = 0x40000000 //only if WinVer >= 5.0.0 (see wingdi.h)
    }

    [DllImport("gdi32.dll")]
    public static extern bool BitBlt(
        IntPtr hObject, int nXDest, int nYDest, int nWidth,
        int nHeight, IntPtr hObjSource, int nXSrc, int nYSrc, TernaryRasterOperations dwRop);

    private static Bitmap pikselEkranu = new Bitmap(1, 1, System.Drawing.Imaging.PixelFormat.Format32bppArgb);

    public static Color PobierzKolorPiksela(Point położenie)
    {
        using (Graphics gs = Graphics.FromImage(pikselEkranu))
        {
            using (Graphics gd = Graphics.FromHwnd(IntPtr.Zero))
            {
                IntPtr hsDC = gs.GetHdc();
                IntPtr hdDC = gd.GetHdc();
                BitBlt(hsDC, 0, 0, 1, 1, hdDC, położenie.X, położenie.Y, TernaryRasterOperations.SRCCOPY);
                gd.ReleaseHdc();
                gs.ReleaseHdc();
            }
        }
        return pikselEkranu.GetPixel(0, 0);
    }
}

