﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace PrzeciągnijIUpuść
{
    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        //private const string formatLista = "Format_Lista";
        //private const string formatElementListy = "Format_ElementListy";
        //private const string formatElementListyEtykieta = "Format_ElementListyEtykieta";

        private void ListBox_PreviewMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            ListBox lbSender = sender as ListBox;
            ListBoxItem przenoszonyElement = lbSender.GetItemAt(e.GetPosition(lbSender));
            if(przenoszonyElement != null)
            {
                DataObject dane = new DataObject();
                //dane.SetData(formatLista, lbSender);
                //dane.SetData(formatElementListy, przenoszonyElement);
                //dane.SetData(DataFormats.StringFormat, przenoszonyElement.Content as string);                
                dane.SetText(przenoszonyElement.Content as string);
                DragDrop.DoDragDrop(lbSender, dane, /*DragDropEffects.Move |*/ DragDropEffects.Copy);
            }
        }

        private void ListBox_DragEnter(object sender, DragEventArgs e)
        {
            //if (e.KeyStates.HasFlag(DragDropKeyStates.ControlKey)) e.Effects = DragDropEffects.Copy;
            //else e.Effects = DragDropEffects.Move;
            e.Effects = DragDropEffects.Copy;
        }

        private void ListBox_Drop(object sender, DragEventArgs e)
        {
            ListBox lbSender = sender as ListBox;

            //ListBox lbSource = e.Data.GetData(formatLista) as ListBox;
            //ListBoxItem przenoszonyElement = e.Data.GetData(formatElementListy) as ListBoxItem;
            //string etykietaPrzenoszonegoElementu = e.Data.GetData(DataFormats.StringFormat) as string;            
            string etykietaPrzenoszonegoElementu = (e.Data as DataObject).GetText();

            //if (e.KeyStates.HasFlag(DragDropKeyStates.ControlKey)) przenoszonyElement = new ListBoxItem() { Content = przenoszonyElement.Content };
            //else lbSource.Items.Remove(przenoszonyElement);
            ListBoxItem przenoszonyElement = new ListBoxItem() { Content = etykietaPrzenoszonegoElementu };

            int indeks = lbSender.IndexFromPoint(e.GetPosition(lbSender));
            if (indeks < 0) lbSender.Items.Add(przenoszonyElement);
            else lbSender.Items.Insert(indeks, przenoszonyElement);
        }
    }
}
