﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;
using System.Windows.Interop;

namespace KonkursWinForms
{
    public static class WinAPI
    {
        public const uint WM_CLOSE = 16;
        public const uint WM_KEYDOWN = 0x0100;
        public const uint WM_KEYUP = 0x0101;
        public const uint WM_CHAR = 0x0102;
        public const uint WM_SYSKEYDOWN = 0x0104;
        public const uint WM_SYSKEYUO = 0x0105;

        [DllImport("user32.dll")]
        private static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, IntPtr wParam, IntPtr lParam);

        [DllImport("user32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool MessageBeep(uint rodzajDzwieku);

        [DllImport("user32.dll", EntryPoint = "MessageBox", CharSet = CharSet.Unicode)]
        public static extern int _MessageBox(IntPtr hWnd, string text, string caption, uint type);

        public enum StanOkna : uint { Ukryte = 0, Normalne, Zminimalizowane, Zmaksymalizowane, Nieaktywne, Domyślne = 10 }
        [DllImport("kernel32.dll")]
        public static extern uint WinExec(string polecenie, StanOkna stanOkna);

        [DllImport("kernel32.dll")]
        public static extern bool GetDiskFreeSpaceEx
        (
            string katalog,
            ref long wolneMiejsceDlaUzytkownika,
            ref long rozmiarDysku,
            ref long wolneMijesceNaDysku
        );

        [DllImport("kernel32.dll")]
        public static extern uint GetWindowsDirectory(StringBuilder bufor, uint rozmiarBufora);

        public static int? pobierzZajetoscDysku(string katalog)
        {
            long wolneMiejsceDlaUzytkownika = 0;
            long wolneMiejsceNaDysku = 0;
            long rozmiarDysku = 0;
            int? zajeteMiejsceProcenty;
            if (GetDiskFreeSpaceEx(katalog, ref wolneMiejsceDlaUzytkownika, ref rozmiarDysku, ref wolneMiejsceNaDysku))
            {
                zajeteMiejsceProcenty = (int)(100.0 * (rozmiarDysku - wolneMiejsceNaDysku) / rozmiarDysku);
            }
            else
                zajeteMiejsceProcenty = null;

            return zajeteMiejsceProcenty;
        }

        [DllImport("user32.dll")]
        public static extern bool GetCursorPos(ref System.Drawing.Point lpPoint);

        [DllImport("user32.dll")]
        public static extern bool GetPhysicalCursorPos(ref System.Drawing.Point lpPoint);

        [DllImport("user32.dll")]
        public static extern bool SetProcessDPIAware();

        [DllImport("gdi32.dll")]
        public static extern bool BitBlt(IntPtr hObject, int nXDest, int nYDest, int nWidth, int nHeight, IntPtr hObjSource, int nXSrc, int nYSrc, TernaryRasterOperations dwRop);
        public enum TernaryRasterOperations : uint
        {
            SRCCOPY = 0x00CC0020,
            SRCPAINT = 0x00EE0086,
            SRCAND = 0x008800C6,
            SRCINVERT = 0x00660046,
            SRCERASE = 0x00440328,
            NOTSRCCOPY = 0x00330008,
            NOTSRCERASE = 0x001100A6,
            MERGECOPY = 0x00C000CA,
            MERGEPAINT = 0x00BB0226,
            PATCOPY = 0x00F00021,
            PATPAINT = 0x00FB0A09,
            PATINVERT = 0x005A0049,
            DSTINVERT = 0x00550009,
            BLACKNESS = 0x00000042,
            WHITENESS = 0x00FF0062,
            CAPTUREBLT = 0x40000000 
        }

        public static Bitmap pikselEkranu = new Bitmap(1, 1, System.Drawing.Imaging.PixelFormat.Format32bppArgb);

        public static System.Windows.Media.Color PobierzKolorPiksela(System.Drawing.Point polozenie)
        {
            using (Graphics gs = Graphics.FromImage(pikselEkranu))
            {
                using (Graphics gd = Graphics.FromHwnd(IntPtr.Zero))
                {
                    IntPtr hsDC = gs.GetHdc();
                    IntPtr hdDC = gd.GetHdc();
                    BitBlt(hsDC, 0, 0, 1, 1, hdDC, polozenie.X, polozenie.Y, TernaryRasterOperations.SRCCOPY);
                    gd.ReleaseHdc();
                    gs.ReleaseHdc();
                }
            }

            System.Drawing.Color kolor = pikselEkranu.GetPixel(0, 0);
            return System.Windows.Media.Color.FromArgb(kolor.A, kolor.R, kolor.G, kolor.B);
        }
    }
}
