
// ListaOkienDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ListaOkien.h"
#include "ListaOkienDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CListaOkienDlg dialog



CListaOkienDlg::CListaOkienDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_LISTAOKIEN_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CListaOkienDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, list1);
}

BEGIN_MESSAGE_MAP(CListaOkienDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
END_MESSAGE_MAP()


// CListaOkienDlg message handlers

BOOL CListaOkienDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	RECT r;
	list1.GetWindowRect(&r);
	int szerListy = r.right - r.left;
	int szerKolumny = szerListy / 7;

	list1.InsertColumn(0, L"Tytu okna", LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(1, L"Nazwa klasy okna", LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(2, L"ID okna", LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(3, L"Uchwyt", LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(4, L"Stan okna", LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(5, L"Pooenie", LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(6, L"Rozmiar", LVCFMT_LEFT, szerKolumny, 0);

	::EnumWindows((WNDENUMPROC)DodajWiersz, (LPARAM)&list1);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

int CALLBACK CListaOkienDlg::DodajWiersz(HWND uchwytOkna, LPARAM lParam)
{
	if (!::IsWindowVisible(uchwytOkna)) return 1;

	CListCtrl* list = (CListCtrl*)lParam;

	const int MAX_CHAR_SIZE = 128;

	wchar_t tytu[MAX_CHAR_SIZE];
	wchar_t nazwaKlasy[MAX_CHAR_SIZE];
	DWORD idWtkuOkna;
	WINDOWPLACEMENT geometriaOkna;

	::GetWindowText(uchwytOkna, tytu, MAX_CHAR_SIZE);
	::GetClassName(uchwytOkna, nazwaKlasy, MAX_CHAR_SIZE);
	::GetWindowThreadProcessId(uchwytOkna, &idWtkuOkna);
	::GetWindowPlacement(uchwytOkna, &geometriaOkna);

	CString stanOkna;
	switch (geometriaOkna.showCmd)
	{
	case SW_HIDE: stanOkna.Append(L"ukryte"); break;
	case SW_MAXIMIZE: stanOkna.Append(L"max"); break;
	case SW_MINIMIZE: stanOkna.Append(L"min"); break;	
	case SW_NORMAL:
	case SW_SHOWNOACTIVATE:
	case SW_RESTORE: stanOkna.Append(L"normalne"); break;
	default: stanOkna.Append(L"inne"); break;
	}

	int row = list->GetHeaderCtrl()->GetItemCount() - 1;
	int index = list->InsertItem(row, tytu);
	list->SetItem(index, 1, LVIF_TEXT, nazwaKlasy, 0, 0, 0, NULL);
	CString sIdWtku;
	sIdWtku.AppendFormat(L"%d", idWtkuOkna);
	list->SetItem(index, 2, LVIF_TEXT, sIdWtku, 0, 0, 0, NULL);
	CString sUchwytOkna;
	sUchwytOkna.AppendFormat(L"%d", uchwytOkna);
	list->SetItem(index, 3, LVIF_TEXT, sUchwytOkna, 0, 0, 0, NULL);
	list->SetItem(index, 4, LVIF_TEXT, stanOkna, 0, 0, 0, NULL);

	CString sPozycja;
	sPozycja.AppendFormat(L"x=%d, y=%d", geometriaOkna.rcNormalPosition.left, geometriaOkna.rcNormalPosition.top);
	list->SetItem(index, 5, LVIF_TEXT, sPozycja, 0, 0, 0, NULL);

	CString sRozmiar;
	sRozmiar.AppendFormat(L"w=%d, h=%d",
		geometriaOkna.rcNormalPosition.right - geometriaOkna.rcNormalPosition.left,
		geometriaOkna.rcNormalPosition.bottom - geometriaOkna.rcNormalPosition.top);
	list->SetItem(index, 6, LVIF_TEXT, sRozmiar, 0, 0, 0, NULL);

	return 1;
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CListaOkienDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CListaOkienDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

