﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace EdycjaRysunków
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void changeBitmapColorNet(Bitmap bmp, Color colorMin, Color colorMax, Color targetColor)
        {
            Cursor cursor = Cursor.Current;
            Cursor.Current = Cursors.WaitCursor;
            for(int ix = 0; ix < bmp.Width; ++ix)
                for (int iy = 0; iy < bmp.Height; ++iy)
                {
                    Color pixel = bmp.GetPixel(ix, iy);
                    bool warunek =
                        pixel.R >= colorMin.R && pixel.R <= colorMax.R &&
                        pixel.G >= colorMin.G && pixel.G <= colorMax.G &&
                        pixel.B >= colorMin.B && pixel.B <= colorMax.B;
                    if (warunek) bmp.SetPixel(ix, iy, targetColor);
                }
            Cursor.Current = cursor;
        }

        private void changeBitmapColorSystem(Bitmap bmp, Color colorMin, Color colorMax, Color targetColor)
        {
            Rectangle bmpBounds = new Rectangle(0, 0, bmp.Width, bmp.Height);
            BitmapData bmpData = bmp.LockBits(bmpBounds, ImageLockMode.ReadWrite, PixelFormat.Format32bppArgb);
            byte[] bmpBytes = new byte[Math.Abs(bmpData.Stride) * bmp.Height];
            IntPtr scan0 = bmpData.Scan0;

            Marshal.Copy(scan0, bmpBytes, 0, bmpBytes.Length);

            for (int i = 0; i < bmpBytes.Length; i += 4)
            {
                byte b = bmpBytes[i + 0];
                byte g = bmpBytes[i + 1];
                byte r = bmpBytes[i + 2];
                byte a = bmpBytes[i + 3];

                bool warunek =
                    r >= colorMin.R && r <= colorMax.R &&
                    g >= colorMin.G && g <= colorMax.G &&
                    b >= colorMin.B && b <= colorMax.B;

                if (warunek)
                {
                    bmpBytes[i + 0] = targetColor.B;
                    bmpBytes[i + 1] = targetColor.G;
                    bmpBytes[i + 2] = targetColor.R;
                    bmpBytes[i + 3] = a;
                }
            }

            Marshal.Copy(bmpBytes, 0, scan0, bmpBytes.Length);
            bmp.UnlockBits(bmpData);
        }


        private void button1_Click(object sender, EventArgs e)
        {
            Bitmap bmp = pictureBox1.Image as Bitmap;
            if (bmp == null) MessageBox.Show("Nieodpowiedni format rysunku");
            else
            {
                changeBitmapColorNet(
                   bmp,
                    Color.FromArgb(0, 0, 15),
                    Color.FromArgb(50, 50, 255),
                    Color.FromArgb(0, 255, 0));
                pictureBox1.Refresh();
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Bitmap bmp = pictureBox1.Image as Bitmap;
            if (bmp == null) MessageBox.Show("Nieodpowiedni format rysunku");
            else
            {
                changeBitmapColorSystem(
                   bmp,
                    Color.FromArgb(0, 0, 15),
                    Color.FromArgb(50, 50, 255),
                    Color.FromArgb(0, 255, 0));
                pictureBox1.Refresh();
            }
        }
    }
}
