#include "Okno.h"
#include "Zasoby.h"

#pragma region "Podstawy"
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	POINT pooenieOkna = { 100,100 };
	POINT rozmiarOkna = { 800,600 };
	if (!okno.Init(hInstance, pooenieOkna, rozmiarOkna))
	{
		MessageBox(NULL, "Inicjacja okna nie powioda si", "Aplikacja Win32", MB_OK | MB_ICONERROR);
		return EXIT_FAILURE;
	}
	else return okno.Run();
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return okno.WndProc(hWnd, uMsg, wParam, lParam);
}

bool COkno::Init(HINSTANCE uchwytAplikacji, POINT pooenieOkna, POINT rozmiarOkna)
{
	char nazwaOkna[] = "Aplikacja Windows";

	//WNDCLASSEX wc;
	wc.cbSize = sizeof(wc);
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc = (WNDPROC)::WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = uchwytAplikacji;
	wc.hIcon = LoadIcon(uchwytAplikacji, MAKEINTRESOURCE(IDI_ICON1));
	wc.hIconSm = LoadIcon(uchwytAplikacji, MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor = LoadCursor(uchwytAplikacji, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = nazwaOkna;

	if (RegisterClassEx(&wc) == 0) return false;

	DWORD stylOkna = WS_OVERLAPPEDWINDOW;

	uchwytOkna = CreateWindow(
		nazwaOkna,
		nazwaOkna,
		stylOkna,
		pooenieOkna.x, pooenieOkna.y,
		rozmiarOkna.x, rozmiarOkna.y,
		NULL,
		NULL,
		uchwytAplikacji,
		NULL);

	if (uchwytOkna == NULL) return false;	

	//Pokazanie okna
	ShowWindow(uchwytOkna, SW_SHOW);
	//UpdateWindow(uchwytOkna);

	return true;
}

WPARAM COkno::Run()
{
	//ptla gwna	
	MSG msg;
	while (GetMessage(&msg, NULL, 0, 0))
	{
		licznikKomunikatwRun++;
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}
#pragma endregion

LRESULT COkno::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	licznikKomunikatwWndProc++;
	switch (uMsg)
	{
	case WM_CREATE:
		TwrzPrzyciski(hWnd);
		break;
	case WM_COMMAND:
		ObsugaPrzyciskw(wParam);
		break;
	case WM_DESTROY:
		PostQuitMessage(EXIT_SUCCESS);
		break;
	case WM_SIZE:
		Beep(100, 100);

		{
			char sLicznikKomunikatwRun[255] = "";
			_itoa_s(licznikKomunikatwRun, sLicznikKomunikatwRun, 10);
			char sLicznikKomunikatwWndProc[255] = "";
			_itoa_s(licznikKomunikatwWndProc, sLicznikKomunikatwWndProc, 10);
			strcat_s(sLicznikKomunikatwRun, " ");
			strcat_s(sLicznikKomunikatwRun, sLicznikKomunikatwWndProc);
			SetWindowText(uchwytOkna, sLicznikKomunikatwRun);
		}

		break;
	default:
		//automatyczne przetwarzanie komunikatw
		return DefWindowProc(hWnd, uMsg, wParam, lParam);
	}
}

#pragma region "Przyciski"
void COkno::TwrzPrzyciski(HWND uchwytOknaRodzica)
{
	hPrzyciskHello = CreateWindow(
		"Button",
		"Hello WinAPI!",
		WS_CHILD | WS_VISIBLE,
		30, 30, 200, 70, //geometria
		uchwytOknaRodzica,
		(HMENU)ID_BUTTON_HELLO,
		wc.hInstance,
		NULL);
	hPrzyciskZamknij = CreateWindow(
		"Button",
		"Zamknij",
		WS_CHILD | WS_VISIBLE,
		240, 30, 200, 70, //geometria
		uchwytOknaRodzica,
		(HMENU)ID_BUTTON_ZAMKNIJ,
		wc.hInstance,
		NULL);
}

void COkno::ObsugaPrzyciskw(WPARAM idPrzycisku)
{
	switch (idPrzycisku)
	{
	case ID_BUTTON_HELLO:
		MessageBox(uchwytOkna, "Hello, WinAPI!", "Witaj WinAPI!", MB_OK | MB_ICONINFORMATION);
		break;
	case ID_BUTTON_ZAMKNIJ:
		PostMessage(uchwytOkna, WM_CLOSE, 0, 0);
		break;
	}
}
#pragma endregion
