#include "Okno.h"
#include "Zasoby.h"

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	POINT pooenieOkna = { 100,100 };
	POINT rozmiarOkna = { 800,600 };
	okno.Init(hInstance, pooenieOkna, rozmiarOkna);
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return okno.WndProc(hWnd, uMsg, wParam, lParam);
}

bool COkno::Init(HINSTANCE uchwytAplikacji, POINT pooenieOkna, POINT rozmiarOkna)
{
	char nazwaOkna[] = "Aplikacja Windows";

	WNDCLASSEX wc;
	wc.cbSize = sizeof(wc);
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc = (WNDPROC)::WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = uchwytAplikacji;
	wc.hIcon = LoadIcon(uchwytAplikacji, MAKEINTRESOURCE(IDI_ICON1));
	wc.hIconSm = LoadIcon(uchwytAplikacji, MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor = LoadCursor(uchwytAplikacji, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = nazwaOkna;

	if (RegisterClassEx(&wc) == 0) return false;

	DWORD stylOkna = WS_OVERLAPPEDWINDOW;

	uchwytOkna = CreateWindow(
		nazwaOkna,
		nazwaOkna,
		stylOkna,
		pooenieOkna.x, pooenieOkna.y,
		rozmiarOkna.x, rozmiarOkna.y,
		NULL,
		NULL,
		uchwytAplikacji,
		NULL);

	return false;
}

LRESULT COkno::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	default:
		return DefWindowProc(hWnd, uMsg, wParam, lParam);
	}
}
