﻿// MappedFiles.cpp : Definiuje punkt wejścia dla aplikacji.
//

#include "stdafx.h"
#include "MappedFiles.h"
#include <Commdlg.h>
#include "strsafe.h"

#define MAX_LOADSTRING 100

// Zmienne globalne:
HINSTANCE hInst;                                // bieżące wystąpienie
WCHAR szTitle[MAX_LOADSTRING];                  // Tekst paska tytułu
WCHAR szWindowClass[MAX_LOADSTRING];            // nazwa klasy okna głównego
HWND hMainEdit;
HWND hStatusEdit;
HWND hButtonCreate;
HWND hButtonLoad;
HWND hButtonSave;
HWND hButtonOpenExisting;
HWND hButtonUnload;
OPENFILENAME ofn;       // common dialog box structure
TCHAR szFile[260];       // buffer for file name
HANDLE hf;              // file handle
HANDLE hfmappingobj;	//objekt mapujący
LPVOID lpfview;	//adres widoku
DWORD filesize;


// Przekaż dalej deklaracje funkcji dołączone w tym module kodu:
ATOM                MyRegisterClass(HINSTANCE hInstance);
BOOL                InitInstance(HINSTANCE, int);
LRESULT CALLBACK    WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK    About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY wWinMain(_In_ HINSTANCE hInstance,
                     _In_opt_ HINSTANCE hPrevInstance,
                     _In_ LPWSTR    lpCmdLine,
                     _In_ int       nCmdShow)
{
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);

    // TODO: W tym miejscu umieść kod.

    // Inicjuj ciągi globalne
    LoadStringW(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
    LoadStringW(hInstance, IDC_MAPPEDFILES, szWindowClass, MAX_LOADSTRING);
    MyRegisterClass(hInstance);

    // Wykonaj inicjowanie aplikacji:
    if (!InitInstance (hInstance, nCmdShow))
    {
        return FALSE;
    }

    HACCEL hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_MAPPEDFILES));

    MSG msg;

    // Główna pętla komunikatów:
    while (GetMessage(&msg, nullptr, 0, 0))
    {
        if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    return (int) msg.wParam;
}



//
//  FUNKCJA: MyRegisterClass()
//
//  PRZEZNACZENIE: Rejestruje klasę okna.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
    WNDCLASSEXW wcex;

    wcex.cbSize = sizeof(WNDCLASSEX);

    wcex.style          = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = WndProc;
    wcex.cbClsExtra     = 0;
    wcex.cbWndExtra     = 0;
    wcex.hInstance      = hInstance;
    wcex.hIcon          = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MAPPEDFILES));
    wcex.hCursor        = LoadCursor(nullptr, IDC_ARROW);
    wcex.hbrBackground  = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName   = MAKEINTRESOURCEW(IDC_MAPPEDFILES);
    wcex.lpszClassName  = szWindowClass;
    wcex.hIconSm        = LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

    return RegisterClassExW(&wcex);
}

//
//   FUNKCJA: InitInstance(HINSTANCE, int)
//
//   PRZEZNACZENIE: Zapisuje dojście wystąpienia i tworzy okno główne
//
//   KOMENTARZE:
//
//        W tej funkcji dojście wystąpienia jest zapisywane w zmiennej globalnej i
//        jest tworzone i wyświetlane okno główne programu.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   hInst = hInstance; // Przechowuj dojście wystąpienia w naszej zmiennej globalnej

   HWND hWnd = CreateWindowW(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, 640, 300, nullptr, nullptr, hInstance, nullptr);

   if (!hWnd)
   {
      return FALSE;
   }

   hMainEdit = CreateWindowExA( NULL, "Edit", NULL , WS_CHILD | WS_VISIBLE | WS_BORDER, 10, 10, 600, 40, hWnd, NULL, hInstance, NULL);
   hStatusEdit = CreateWindowExA(NULL, "Edit", NULL, WS_CHILD | WS_VISIBLE | WS_BORDER | ES_MULTILINE | ES_READONLY, 10, 60, 600, 100, hWnd, NULL, hInstance, NULL);
   hButtonLoad = CreateWindowExA(NULL, "Button", "Load file", WS_CHILD | WS_VISIBLE, 10, 170, 100, 30, hWnd, NULL, hInstance, NULL);
   hButtonCreate = CreateWindowExA(NULL, "Button", "Create mapping object", WS_CHILD | WS_VISIBLE, 120, 170, 200, 30, hWnd, NULL, hInstance, NULL);
   hButtonUnload = CreateWindowExA(NULL, "Button", "Unload", WS_CHILD | WS_VISIBLE, 330, 170, 70, 30, hWnd, NULL, hInstance, NULL);
   hButtonSave = CreateWindowExA(NULL, "Button", "Save", WS_CHILD | WS_VISIBLE, 410, 170, 50, 30, hWnd, NULL, hInstance, NULL);
   hButtonOpenExisting = CreateWindowExA(NULL, "Button", "Open existing", WS_CHILD | WS_VISIBLE, 470, 170, 110, 30, hWnd, NULL, hInstance, NULL);

   // Initialize OPENFILENAME
   ZeroMemory(&ofn, sizeof(ofn));
   ofn.lStructSize = sizeof(ofn);
   ofn.hwndOwner = hWnd;
   ofn.lpstrFile = szFile;
   // Set lpstrFile[0] to '\0' so that GetOpenFileName does not 
   // use the contents of szFile to initialize itself.
   ofn.lpstrFile[0] = '\0';
   ofn.nMaxFile = sizeof(szFile);
   ofn.lpstrFilter = _T("All\0*.*\0Text\0*.TXT\0");
   ofn.nFilterIndex = 1;
   ofn.lpstrFileTitle = NULL;
   ofn.nMaxFileTitle = 0;
   ofn.lpstrInitialDir = NULL;
   ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  FUNKCJA: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PRZEZNACZENIE: Przetwarza komunikaty dla okna głównego.
//
//  WM_COMMAND  - przetwarzaj menu aplikacji
//  WM_PAINT    - Maluj okno główne
//  WM_DESTROY  - opublikuj komunikat o wyjściu i wróć
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_COMMAND:
        {
            if ((HWND)lParam == hButtonLoad)
			{
				// Display the Open dialog box. 
				bool error = false;
				bool status = true;
				do
				{
					if (GetOpenFileName(&ofn) == TRUE)
						hf = CreateFile(ofn.lpstrFile,
							GENERIC_READ | GENERIC_WRITE,
							0,
							NULL,
							OPEN_EXISTING,
							FILE_ATTRIBUTE_NORMAL,
							(HANDLE)NULL);
					else
					{
						status = false;
						int decision = MessageBox(NULL, _T("Error reading the file!"), _T("ERROR!"), MB_RETRYCANCEL | MB_ICONERROR);
						if (decision == 4)  error = true;
						else error = false;
					}
				} while (error);
				int idx = GetWindowTextLength(hStatusEdit);
				SendMessage(hStatusEdit, EM_SETSEL, (WPARAM)idx, (LPARAM)idx);
				if (status)
				{
					SendMessage(hStatusEdit, EM_REPLACESEL, 0, (LPARAM)TEXT("Successfully loaded a file: \n"));
					SendMessage(hStatusEdit, EM_REPLACESEL, 0, (LPARAM)(ofn.lpstrFile));
					SendMessage(hStatusEdit, EM_REPLACESEL, 0, (LPARAM)TEXT("\n"));
					filesize = GetFileSize(hf, &filesize);
				}
			}
			if ((HWND)lParam == hButtonCreate)
			{
				if (hf != NULL)
				{
					hfmappingobj = CreateFileMappingW(
						hf,
						NULL,
						PAGE_READWRITE,
						0, 0, //wartość brana z pliku
						(LPCWSTR)"mapobj"
					);
				}
				if (hfmappingobj == NULL)
				{
					MessageBox(NULL, _T("Could not create the mapping object!\nIs this a valid text file?"), _T("ERROR!"), MB_OK | MB_ICONERROR);
				}
				else
				{
					int idx = GetWindowTextLength(hStatusEdit);
					SendMessage(hStatusEdit, EM_SETSEL, (WPARAM)idx, (LPARAM)idx);
					SendMessage(hStatusEdit, EM_REPLACESEL, 0, (LPARAM)_T("Successfully created a file mapping object. \n"));
				}
				if (hfmappingobj)
				{
					lpfview = MapViewOfFile(
						hfmappingobj,
						FILE_MAP_ALL_ACCESS,
						0, 0, 0
					);
				}
				if (lpfview == NULL)
				{
					MessageBox(hWnd, _T("Could not map a view of the file!"), _T("ERROR!"), MB_OK | MB_ICONERROR);
				}
				else
				{
					int idx = GetWindowTextLength(hStatusEdit);
					SendMessage(hStatusEdit, EM_SETSEL, (WPARAM)idx, (LPARAM)idx);
					SendMessage(hStatusEdit, EM_REPLACESEL, 0, (LPARAM)_T("Successfully mapped a view of the file. \n"));
				}

				if (lpfview)
				{
					bool unfinished = true;
					while (unfinished)
					{
						char* fileContents=NULL;

						__try
						{
							fileContents = (char*) lpfview;
							unfinished = false;
						}
						__except (GetExceptionCode() == EXCEPTION_IN_PAGE_ERROR ?
							EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
						{
							int decision = MessageBox(hWnd, _T("Could not read from the file view.\nThe memory may be occupied by another program."), _T("ERROR!"), MB_RETRYCANCEL | MB_ICONERROR);
							if(decision==4) unfinished = true;
						}
						if(fileContents) SetWindowText(hMainEdit, (LPCSTR)fileContents);
					}
				}
			}
			if ((HWND)lParam == hButtonUnload)
			{
				if (lpfview)
				{
					if (UnmapViewOfFile(lpfview) == 0) MessageBox(NULL, _T("Error unmapping the view!"), _T("ERROR!"), MB_OK | MB_ICONERROR);
				}
				if (hfmappingobj)
				{
					if (CloseHandle(hfmappingobj) == 0) MessageBox(NULL, _T("Error closing the file mapping object!"), _T("ERROR!"), MB_OK | MB_ICONERROR);
				}
				if (hf)
				{
					if (CloseHandle(hf) == 0) MessageBox(NULL, _T("Error closing the file!"), _T("ERROR!"), MB_OK | MB_ICONERROR);
					else hf = 0;
				}
				SetWindowText(hMainEdit, _T(""));
				SetWindowText(hStatusEdit, _T(""));
			}
			if ((HWND)lParam == hButtonSave)
			{
				LPTSTR stringBuf = new char[64];
				int sz = GetWindowText(hMainEdit,stringBuf,64);

				__try
				{
					StringCchCopy((LPTSTR)lpfview, 64, stringBuf);
				}
				__except (GetExceptionCode() == EXCEPTION_IN_PAGE_ERROR ?
					EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
				{
					MessageBox(hWnd, _T("Failed to write to the view."), _T("ERROR!"), MB_OK | MB_ICONERROR);
				}
				
				if (!FlushViewOfFile(lpfview, 0))
				{
					MessageBox(hWnd, _T("Could not flush memory to disk.\n"), _T("ERROR!"), MB_OK | MB_ICONERROR);
				}
			}
			if ((HWND)lParam == hButtonOpenExisting)
			{
				if (hf == NULL)
				{
					hfmappingobj = CreateFileMappingW(
						INVALID_HANDLE_VALUE,
						NULL,
						PAGE_READWRITE,
						0, 32,
						(LPCWSTR)"mapobj"
					);
				}
				else
					MessageBox(NULL, _T("There is already a file open."), _T("Warning!"), MB_OK | MB_ICONASTERISK);
				if (hfmappingobj == NULL)
				{
					MessageBox(NULL, _T("Could not create the mapping object!\nIs this a valid text file?"), _T("ERROR!"), MB_OK | MB_ICONERROR);
				}
				else
				{
					int idx = GetWindowTextLength(hStatusEdit);
					SendMessage(hStatusEdit, EM_SETSEL, (WPARAM)idx, (LPARAM)idx);
					SendMessage(hStatusEdit, EM_REPLACESEL, 0, (LPARAM)_T("Created file mapping from existing mapping object. \n"));
				}
				if (hfmappingobj)
				{
					lpfview = MapViewOfFile(
						hfmappingobj,
						FILE_MAP_ALL_ACCESS,
						0, 0, 0
					);
				}
				if (lpfview == NULL)
				{
					MessageBox(hWnd, _T("Could not map a view of the file!"), _T("ERROR!"), MB_OK | MB_ICONERROR);
				}
				else
				{
					int idx = GetWindowTextLength(hStatusEdit);
					SendMessage(hStatusEdit, EM_SETSEL, (WPARAM)idx, (LPARAM)idx);
					SendMessage(hStatusEdit, EM_REPLACESEL, 0, (LPARAM)_T("Successfully mapped a view of the file. \n"));
				}

				if (lpfview)
				{
					bool unfinished = true;
					while (unfinished)
					{
						char* fileContents = NULL;

						__try
						{
							fileContents = (char*)lpfview;
							unfinished = false;
						}
						__except (GetExceptionCode() == EXCEPTION_IN_PAGE_ERROR ?
							EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
						{
							int decision = MessageBox(hWnd, _T("Could not read from the file view.\nThe memory may be occupied by another program."), _T("ERROR!"), MB_RETRYCANCEL | MB_ICONERROR);
							if (decision == 4) unfinished = true;
						}
						if (fileContents) SetWindowText(hMainEdit, (LPCSTR)fileContents);
					}
				}
			}


			int wmId = LOWORD(wParam);
            // Analizuj zaznaczenia menu:
            switch (wmId)
            {
            case IDM_ABOUT:
                DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
                break;
            case IDM_EXIT:
                DestroyWindow(hWnd);
                break;
            default:
                return DefWindowProc(hWnd, message, wParam, lParam);
            }
        }
        break;
    case WM_PAINT:
        {
            PAINTSTRUCT ps;
            HDC hdc = BeginPaint(hWnd, &ps);
            // TODO: Tutaj dodaj kod rysujący używający elementu hdc...
            EndPaint(hWnd, &ps);
        }
        break;
    case WM_DESTROY:
        PostQuitMessage(0);
        break;
    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}

// Procedura obsługi komunikatów dla okna informacji o programie.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    UNREFERENCED_PARAMETER(lParam);
    switch (message)
    {
    case WM_INITDIALOG:
        return (INT_PTR)TRUE;

    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
        {
            EndDialog(hDlg, LOWORD(wParam));
            return (INT_PTR)TRUE;
        }
        break;
    }
    return (INT_PTR)FALSE;
}
