#include "stdafx.h"

//JM: kod cakowicie skopiowany ze strony 
//https://docs.microsoft.com/en-us/windows/desktop/procthread/using-the-thread-pool-functions


void CALLBACK MyWaitCallback(PTP_CALLBACK_INSTANCE Instance,PVOID Parameter,PTP_WAIT Wait,TP_WAIT_RESULT WaitResult)
{
	UNREFERENCED_PARAMETER(Instance);
	UNREFERENCED_PARAMETER(Parameter);
	UNREFERENCED_PARAMETER(Wait);
	UNREFERENCED_PARAMETER(WaitResult);

	_tprintf(_T("MyWaitCallback: wait is over.\n"));
}

void CALLBACK MyTimerCallback(PTP_CALLBACK_INSTANCE Instance,PVOID Parameter,PTP_TIMER Timer)
{
	UNREFERENCED_PARAMETER(Instance);
	UNREFERENCED_PARAMETER(Parameter);
	UNREFERENCED_PARAMETER(Timer);

	_tprintf(_T("MyTimerCallback: timer has fired.\n"));
}

void CALLBACK MyWorkCallback(PTP_CALLBACK_INSTANCE Instance,PVOID Parameter,PTP_WORK Work)
{
	UNREFERENCED_PARAMETER(Instance);
	UNREFERENCED_PARAMETER(Parameter);
	UNREFERENCED_PARAMETER(Work);

	BOOL bRet = FALSE;
	{
		_tprintf(_T("MyWorkCallback: Task performed.\n"));
	}
	return;
}
 
void DemoCleanupPersistentWorkTimer()
{
	BOOL bRet = FALSE;
	PTP_WORK work = NULL;
	PTP_TIMER timer = NULL;
	PTP_POOL pool = NULL;
	PTP_WORK_CALLBACK workcallback = MyWorkCallback;
	PTP_TIMER_CALLBACK timercallback = MyTimerCallback;
	TP_CALLBACK_ENVIRON CallBackEnviron;
	PTP_CLEANUP_GROUP cleanupgroup = NULL;
	FILETIME FileDueTime;
	ULARGE_INTEGER ulDueTime;
	UINT rollback = 0;

	InitializeThreadpoolEnvironment(&CallBackEnviron);
	pool = CreateThreadpool(NULL);

	if (NULL == pool) {
		_tprintf(_T("CreateThreadpool failed. LastError: %u\n"),
			GetLastError());
		goto main_cleanup;
	}

	rollback = 1; 
	SetThreadpoolThreadMaximum(pool, 1);

	bRet = SetThreadpoolThreadMinimum(pool, 1);

	if (FALSE == bRet) {
		_tprintf(_T("SetThreadpoolThreadMinimum failed. LastError: %u\n"),
			GetLastError());
		goto main_cleanup;
	}

	cleanupgroup = CreateThreadpoolCleanupGroup();

	if (NULL == cleanupgroup) {
		_tprintf(_T("CreateThreadpoolCleanupGroup failed. LastError: %u\n"),
			GetLastError());
		goto main_cleanup;
	}

	rollback = 2; 
	SetThreadpoolCallbackPool(&CallBackEnviron, pool);

	SetThreadpoolCallbackCleanupGroup(&CallBackEnviron,cleanupgroup,NULL);

	work = CreateThreadpoolWork(workcallback,NULL,&CallBackEnviron);

	if (NULL == work) {
		_tprintf(_T("CreateThreadpoolWork failed. LastError: %u\n"),
			GetLastError());
		goto main_cleanup;
	}

	rollback = 3;  
	SubmitThreadpoolWork(work);

	timer = CreateThreadpoolTimer(timercallback,NULL,&CallBackEnviron);


	if (NULL == timer) {
		_tprintf(_T("CreateThreadpoolTimer failed. LastError: %u\n"),
			GetLastError());
		goto main_cleanup;
	}

	rollback = 4; 
	ulDueTime.QuadPart = (ULONGLONG)-(1 * 10 * 1000 * 1000);
	FileDueTime.dwHighDateTime = ulDueTime.HighPart;
	FileDueTime.dwLowDateTime = ulDueTime.LowPart;

	SetThreadpoolTimer(timer,&FileDueTime,0,0);
	Sleep(1500);
	CloseThreadpoolCleanupGroupMembers(cleanupgroup,FALSE,NULL);

	rollback = 2;
	goto main_cleanup;

main_cleanup:
	switch (rollback) {
	case 4:
	case 3:
		CloseThreadpoolCleanupGroupMembers(cleanupgroup,FALSE, NULL);
	case 2:
		CloseThreadpoolCleanupGroup(cleanupgroup);
	case 1:
		CloseThreadpool(pool);

	default:
		break;
	}

	return;
}

void DemoNewRegisterWait()
{
	PTP_WAIT Wait = NULL;
	PTP_WAIT_CALLBACK waitcallback = MyWaitCallback;
	HANDLE hEvent = NULL;
	UINT i = 0;
	UINT rollback = 0;

	hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

	if (NULL == hEvent) {
		return;
	}
	rollback = 1;

	Wait = CreateThreadpoolWait(waitcallback,NULL,NULL);

	if (NULL == Wait) {
		_tprintf(_T("CreateThreadpoolWait failed."),
			GetLastError());
		goto new_wait_cleanup;
	}
	rollback = 2;

	for (i = 0; i < 5; i++) {
		SetThreadpoolWait(Wait,hEvent,NULL);

		SetEvent(hEvent);
		Sleep(500);
		WaitForThreadpoolWaitCallbacks(Wait, FALSE);
	}

new_wait_cleanup:
	switch (rollback) {
	case 2:
		SetThreadpoolWait(Wait, NULL, NULL);
		CloseThreadpoolWait(Wait);
	case 1:
		CloseHandle(hEvent);
	default:
		break;
	}
	return;
}

int main(void) {
	DemoNewRegisterWait();
	DemoCleanupPersistentWorkTimer();
	return 0;
}


