/*
// WybudzanieKomputera.cpp: Definiuje punkt wejścia dla aplikacji.
//

#include "stdafx.h"
#include "WybudzanieKomputera.h"

#define MAX_LOADSTRING 100

// Zmienne globalne:
HINSTANCE hInst;                                // bieżące wystąpienie
WCHAR szTitle[MAX_LOADSTRING];                  // Tekst paska tytułu
WCHAR szWindowClass[MAX_LOADSTRING];            // nazwa klasy okna głównego

// Przekaż dalej deklaracje funkcji dołączonych w tym module kodu:
ATOM                MyRegisterClass(HINSTANCE hInstance);
BOOL                InitInstance(HINSTANCE, int);
LRESULT CALLBACK    WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK    About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY wWinMain(_In_ HINSTANCE hInstance,
                     _In_opt_ HINSTANCE hPrevInstance,
                     _In_ LPWSTR    lpCmdLine,
                     _In_ int       nCmdShow)
{
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);

    // TODO: W tym miejscu umieść kod.

    // Zainicjuj ciągi globalne
    LoadStringW(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
    LoadStringW(hInstance, IDC_WYBUDZANIEKOMPUTERA, szWindowClass, MAX_LOADSTRING);
    MyRegisterClass(hInstance);

    // Wykonaj inicjacje aplikacji:
    if (!InitInstance (hInstance, nCmdShow))
    {
        return FALSE;
    }

    HACCEL hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_WYBUDZANIEKOMPUTERA));

    MSG msg;

    // Główna pętla wiadomości:
    while (GetMessage(&msg, nullptr, 0, 0))
    {
        if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    return (int) msg.wParam;
}



//
//  FUNKCJA: MyRegisterClass()
//
//  CEL: Rejestruje klasę okna.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
    WNDCLASSEXW wcex;

    wcex.cbSize = sizeof(WNDCLASSEX);

    wcex.style          = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = WndProc;
    wcex.cbClsExtra     = 0;
    wcex.cbWndExtra     = 0;
    wcex.hInstance      = hInstance;
    wcex.hIcon          = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_WYBUDZANIEKOMPUTERA));
    wcex.hCursor        = LoadCursor(nullptr, IDC_ARROW);
    wcex.hbrBackground  = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName   = MAKEINTRESOURCEW(IDC_WYBUDZANIEKOMPUTERA);
    wcex.lpszClassName  = szWindowClass;
    wcex.hIconSm        = LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

    return RegisterClassExW(&wcex);
}

//
//   FUNKCJA: InitInstance(HINSTANCE, int)
//
//   CEL: Zapisuje dojście wystąpienia i tworzy okno główne
//
//   KOMENTARZE:
//
//        W tej funkcji dojście wystąpienia jest zapisywane w zmiennej globalnej i
//        jest tworzone i wyświetlane okno główne programu.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   hInst = hInstance; // Przechowuj dojście wystąpienia w zmiennej globalnej

   HWND hWnd = CreateWindowW(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, nullptr, nullptr, hInstance, nullptr);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  FUNKCJA: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  CEL: Przetwarza wiadomości dla okna głównego.
//
//  WM_COMMAND — przetwarzaj menu aplikacji
//  WM_PAINT — pomaluj okno główne
//  WM_DESTROY — opublikuj komunikat o rezygnacji i wróć
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_COMMAND:
        {
            int wmId = LOWORD(wParam);
            // Analizuj zaznaczenia menu:
            switch (wmId)
            {
            case IDM_ABOUT:
                DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
                break;
            case IDM_EXIT:
                DestroyWindow(hWnd);
                break;
            default:
                return DefWindowProc(hWnd, message, wParam, lParam);
            }
        }
        break;
    case WM_PAINT:
        {
            PAINTSTRUCT ps;
            HDC hdc = BeginPaint(hWnd, &ps);
            // TODO: tutaj dodaj kod rysowania używający elementu hdc...
            EndPaint(hWnd, &ps);
        }
        break;
    case WM_DESTROY:
        PostQuitMessage(0);
        break;
    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}

//Procedura obsługi wiadomości dla okna informacji o programie.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    UNREFERENCED_PARAMETER(lParam);
    switch (message)
    {
    case WM_INITDIALOG:
        return (INT_PTR)TRUE;

    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
        {
            EndDialog(hDlg, LOWORD(wParam));
            return (INT_PTR)TRUE;
        }
        break;
    }
    return (INT_PTR)FALSE;
}
*/

#include "stdafx.h"
#include <Windows.h>

#define _SECOND 10000000

MSG Message;
HWND hButtonOK, hButtonCancel, hButtonSet, hEditSet;
HANDLE hTimer;
BOOL bSuccess, bCancel;
HANDLE hThread;
DWORD threadID;
__int64 qwDuetime;
LARGE_INTEGER liWakeTime;

DWORD WINAPI ThreadTimerFunc(LPVOID *lpParam)
{
	liWakeTime.QuadPart = -((int)qwDuetime * _SECOND);
	hTimer = CreateWaitableTimer(NULL, TRUE, "TIMER");
	bSuccess = SetWaitableTimer(hTimer, &liWakeTime, 0, NULL, NULL, TRUE); //Uwaga! Ostatni argument - czy wybudzać z uśpienia!
	if (bSuccess) MessageBox(NULL, TEXT("Timer ustawiony"), TEXT("Powiadomienie"), MB_ICONEXCLAMATION);
	else MessageBox(NULL, TEXT("Błąd podczas ustawiania timera"), TEXT("Błąd"), MB_ICONINFORMATION);
	if (WaitForSingleObject(hTimer, INFINITE) != WAIT_OBJECT_0) MessageBox(NULL, TEXT("Coś poszło nie tak"), TEXT("Błąd"), MB_ICONEXCLAMATION);
	else MessageBox(NULL, TEXT("Powodzenie"), TEXT("Powiadomienie"), MB_ICONINFORMATION);
	CloseHandle(hTimer);
	return 0;
}

LRESULT CALLBACK WndProc(HWND hWindow, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
	case WM_CLOSE:
		DestroyWindow(hWindow);
		break;
	case WM_COMMAND:
	{
		if ((HWND)lParam == hButtonOK)
		{
			hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)ThreadTimerFunc, NULL, 0, &threadID);
		}
		//if ((HWND)lParam == hButtonCancel) DestroyWindow(hWindow);
		if ((HWND)lParam == hButtonCancel)
		{
			bCancel = CancelWaitableTimer(hTimer);
			if (bCancel) MessageBox(NULL, TEXT("Timer anulowany"), TEXT("Powiadomienie"), MB_ICONINFORMATION);
			else MessageBox(NULL, TEXT("Anulowanie timera nie powiodło się"), TEXT("Błąd"), MB_ICONWARNING);
		}
		if ((HWND)lParam == hButtonSet)
		{
			int IDN_SET = GetDlgCtrlID(hEditSet); //1, które ustaliliśmy przy CreateWindowEx
			qwDuetime = GetDlgItemInt(hWindow, IDN_SET, &bSuccess, FALSE);
			if (!bSuccess) MessageBox(NULL, TEXT("To nie jest liczba całkowita"), TEXT("Błąd"), MB_ICONWARNING);
		}
	}
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWindow, msg, wParam, lParam);
	}
	return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	const char windowsName[] = "WakeUp";

	WNDCLASSEX wc;
	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = 0;
	wc.lpfnWndProc = WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = windowsName;
	wc.hIconSm = LoadIcon(NULL, IDI_APPLICATION);

	if (RegisterClassEx(&wc) == 0) return false;

	HWND hWindow = CreateWindowEx(WS_EX_CLIENTEDGE, windowsName, TEXT("WakeUp"), WS_OVERLAPPED | WS_MINIMIZEBOX | WS_SYSMENU, CW_USEDEFAULT, CW_USEDEFAULT, 300, 200, NULL, NULL, hInstance, NULL);
	if (!hWindow) MessageBox(NULL, TEXT("Błąd podczas tworzenia okna"), TEXT("Błąd"), MB_ICONERROR);
	ShowWindow(hWindow, SW_SHOW);
	UpdateWindow(hWindow);

	//hEditSet musi być inicjowane na początku, bo inaczej błąd w odczycie zawartości pola tekstowego?!?!?!!?
	hEditSet = CreateWindowEx(WS_EX_CLIENTEDGE, "EDIT", NULL, WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL | WS_TABSTOP, 50, 25, 60, 30, hWindow, (HMENU)1, hInstance, NULL); //1 - identyfikator tego pola tekstowego
	hButtonSet = CreateWindowEx(0, "BUTTON", "Ustaw", WS_CHILD | WS_VISIBLE, 150, 25, 60, 30, hWindow, NULL, hInstance, NULL);
	hButtonOK = CreateWindowEx(0, "BUTTON", "OK", WS_CHILD | WS_VISIBLE, 50, 95, 60, 30, hWindow, NULL, hInstance, NULL);
	hButtonCancel = CreateWindowEx(0, "BUTTON", "Anuluj", WS_CHILD | WS_VISIBLE, 150, 95, 60, 30, hWindow, NULL, hInstance, NULL);	

	while (GetMessage(&Message, NULL, 0, 0))
	{
		TranslateMessage(&Message);
		DispatchMessage(&Message);
	}

	return 0;
}