﻿using System;
using System.Windows.Input;

namespace WinApi.Demo.Client.HTTP.ViewModel
{
    public class RelayCommand : ICommand
    {
        Func<object, bool> canExecute = null;
        Action<object> execute = null;

        public RelayCommand(Action<object> execute, Func<object, bool> canExecute = null)
        {
            if (execute == null) throw new ArgumentNullException(nameof(execute));
            else
            {
                this.execute = execute;
                this.canExecute = canExecute;
            }
        }

        public event EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        public bool CanExecute(object parameter)
        {
            if (canExecute == null) return true;
            else return canExecute(parameter);
        }

        public void Execute(object parameter)
        {
            execute(parameter);
        }
    }
}
