#include <Windows.h>
#include <tchar.h>

SERVICE_STATUS			g_ServiceStatus = { 0 };
SERVICE_STATUS_HANDLE	g_StatusHandle = NULL;
HANDLE					g_ServicesStopEvent = INVALID_HANDLE_VALUE;

VOID WINAPI ServiceMain(DWORD argc, LPSTR *argv);
VOID WINAPI ServiceCtrlHandler(DWORD);
DWORD WINAPI ServiceWorkerThread(LPVOID lpParam);

#define SERVICE_NAME ((wchar_t *)L"Witaj uslugo!")

int _tmain(int argc, TCHAR *argv[])
{
	OutputDebugString(_T("Witaj usugo!: Main: Entry"));

	SERVICE_TABLE_ENTRY ServiceTable[] =
	{
		{SERVICE_NAME, (LPSERVICE_MAIN_FUNCTION)ServiceMain},
		{NULL,NULL}
	};

	if (StartServiceCtrlDispatcher(ServiceTable) == FALSE)
	{
		OutputDebugString(_T("Witaj usugo!: Main: StartServiceCtrlDispatcher returned error"));
		return GetLastError();
	}

	OutputDebugString(_T("Witaj usugo: Main: Exit"));
	
	return 0;
}

VOID WINAPI ServiceMain(DWORD argc, LPSTR * argv)
{
	DWORD Status = E_FAIL;

	OutputDebugString(_T("Witaj usugo!: ServiceMain: Entry"));

	g_StatusHandle = RegisterServiceCtrlHandler(SERVICE_NAME, ServiceCtrlHandler);

	if (g_StatusHandle == NULL)
	{
		OutputDebugString(_T("Witaj usugo!: ServiceMain: RegisterServiceHandler returned error"));
		OutputDebugString(_T("Witaj usugo!: ServiceMain: EXIT"));
		return;
	}

	// Mwimy SCM e usuga startuje
	ZeroMemory(&g_ServiceStatus, sizeof(g_ServiceStatus));
	g_ServiceStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
	g_ServiceStatus.dwControlsAccepted = 0;
	g_ServiceStatus.dwCurrentState = SERVICE_START_PENDING;
	g_ServiceStatus.dwWin32ExitCode = 0;
	g_ServiceStatus.dwServiceSpecificExitCode = 0;
	g_ServiceStatus.dwCheckPoint = 0;

	if (SetServiceStatus(g_StatusHandle, &g_ServiceStatus) == FALSE)
	{
		OutputDebugString(_T("Witaj usugo!: ServiceMain: SetServiceStatus returned error"));
	}

	// konieczne do uruchomienia usugi
	OutputDebugString(_T("Witaj usugo!: ServiceMain: Performing Service Start Operations"));

	// tworzenie zdarzenia stop, na ktry pniej bdziemy oczekiwa
	g_ServicesStopEvent = CreateEvent(NULL, TRUE, FALSE, NULL);

	if (g_ServicesStopEvent == NULL)
	{
		OutputDebugString(_T("Witaj usugo!: ServiceMain: CreateEvent(g_ServiceStopEvent) returned error"));

		g_ServiceStatus.dwControlsAccepted = 0;
		g_ServiceStatus.dwCurrentState = SERVICE_STOPPED;
		g_ServiceStatus.dwWin32ExitCode = GetLastError();
		g_ServiceStatus.dwCheckPoint = 1;

		if (SetServiceStatus(g_StatusHandle, &g_ServiceStatus) == FALSE)
		{
			OutputDebugString(_T("Witaj usugo!: ServiceMain: SetServiceStatus error"));
			OutputDebugString(_T("Witaj usugo!: ServiceMain: EXIT"));
			return;
		}
	}

	// Mwimy SCM e usuga jest uruchomiona
	g_ServiceStatus.dwControlsAccepted = SERVICE_ACCEPT_STOP;
	g_ServiceStatus.dwCurrentState = SERVICE_RUNNING;
	g_ServiceStatus.dwWin32ExitCode = 0;
	g_ServiceStatus.dwCheckPoint = 0;

	if (SetServiceStatus(g_StatusHandle, &g_ServiceStatus) == FALSE)
	{
		OutputDebugString(_T("Witaj usugo!: ServiceMain: SetServiceStatus returned error"));
	}

	// Uruchamiamy wtek ktry bdzie odpowiedzialny za wykonywanie zada usugi
	HANDLE hThread = CreateThread(NULL, 0, ServiceWorkerThread, NULL, 0, NULL);

	OutputDebugString(_T("Witaj usugo!: ServiceMain: Oczekiwanie na wtek usugi"));

	// Oczekiwanie a wtek usugi zacznie istnie
	WaitForSingleObject(hThread, INFINITE);

	OutputDebugString(_T("Witaj usugo!: ServiceMain: Wtek zgosi si"));

	// Prace porzdkowe
	OutputDebugString(_T("Witaj usugo!: ServiceMain: Wykonywanie prac porzdkowych"));

	CloseHandle(g_ServicesStopEvent);

	g_ServiceStatus.dwControlsAccepted = 0;
	g_ServiceStatus.dwCurrentState = SERVICE_STOPPED;
	g_ServiceStatus.dwWin32ExitCode = 0;
	g_ServiceStatus.dwCheckPoint = 3;

	if (SetServiceStatus(g_StatusHandle, &g_ServiceStatus) == FALSE)
	{
		OutputDebugString(_T("Witaj usugo!: ServiceMain: SetServiceStatus returned error"));
		OutputDebugString(_T("Witaj usugo!: ServiceMain: EXIT"));
		return;
	}

	return;
}

VOID WINAPI ServiceCtrlHandler(DWORD CtrlCode)
{
	OutputDebugString(_T("Witaj usugo!: ServiceCtrlHandler: Entry"));

	switch (CtrlCode)
	{
	case SERVICE_CONTROL_STOP:
		OutputDebugString(_T("Witaj usugo!: ServiceCtrlHandler: SERVICE_CONTROL_STOP Request"));

		if (g_ServiceStatus.dwCurrentState != SERVICE_RUNNING)
			break;

		// Wykonanie zada koniecznych do zatrzymania usugi
		g_ServiceStatus.dwControlsAccepted = 0;
		g_ServiceStatus.dwCurrentState = SERVICE_STOP_PENDING;
		g_ServiceStatus.dwWin32ExitCode = 0;
		g_ServiceStatus.dwCheckPoint = 4;

		// Tutaj mwim wtkowi usugi aby si zacz zamyka
		SetEvent(g_ServicesStopEvent);

		break;

	default:
		break;
	}

	OutputDebugString(_T("Witaj usugo!: ServiceCtrlHandler: Exit"));

	return;
}

DWORD WINAPI ServiceWorkerThread(LPVOID lpParam)
{
	OutputDebugString(_T("Witaj usugo!: ServiceWorkerThread: Entry"));

	// Sprawdzamy co jaki czas czy usuga nie ma dania zatrzymania
	while (WaitForSingleObject(g_ServicesStopEvent, 0) != WAIT_OBJECT_0)
	{
		// w tym miejscu implementujemy dziaanie funkcji


		// poniewaz nie mam dobrego pomyslu na ciao usugi to pie
		Sleep(1000);


	}

	OutputDebugString(_T("Witaj usugo!: ServiceWorkerThread: Exit"));

	return ERROR_SUCCESS;
}