// StrukturalnaObslugaWyjatkow.cpp: Definiuje punkt wejścia dla aplikacji konsolowej.
//

//https://docs.microsoft.com/en-us/windows/desktop/debug/structured-exception-handling

#include "stdafx.h"

#include <stdio.h>
#include <Windows.h>
#include <excpt.h>

int filter(unsigned int code, struct _EXCEPTION_POINTERS* exc)
{
	puts("Filter");
	if (code == EXCEPTION_ACCESS_VIOLATION) //stała z Windows.h
	{
		puts("obsluga wyjatku: naruszenie praw dostepu");
		return EXCEPTION_EXECUTE_HANDLER; //wyjątek został obsłużony
	}
	else if (code == 1) //nasz wyjątek
	{
		puts("obsluga naszego wyjatku");
		return EXCEPTION_EXECUTE_HANDLER; //wyjątek został obsłużony
	}
	else
	{
		puts("wyjatek nie zostal obsluzony");
		return EXCEPTION_CONTINUE_SEARCH;
	}
}

void zwyklaObslugaWyjatkow()
{
	try
	{
		puts("Start: try");
		RaiseException( //try nie wychwytuje tej funkcji!
			1,                    
			0,                    
			0, NULL);             
		puts("Koniec: try");
	}
	catch (...)
	{
		puts("Zwykla obsluga wyjatkow");
	}
}

int main()
{
	int* p = 0x00000000;
	puts("Start");	

	__try
	{
		puts("Start: try 1");
		__try
		{
			puts("Start: try 2");
			
			//*p = 4; //to zgłosi wyjątek naruszenia dostępu

			RaiseException( //samodzielne wywołanie wyjątku
				1,                    // exception code 
				0,                    // continuable exception 
				0, NULL);             // no arguments 

			puts("Koniec: try 2");
		}
		__finally		
		{
			puts("Finally, zakonczenie ");
			puts(AbnormalTermination() ? "nie sekwencyjne" : "sekwencyjne");
		}
		puts("Koniec: try 1");
	}
	__except (filter(GetExceptionCode(), GetExceptionInformation()))
	{
		puts("Except");
	}

	zwyklaObslugaWyjatkow();

	puts("Koniec");

    return 0;
}

