#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#include <string>

#include <time.h>

std::string sKlasaOkna = "Klasa okna";

LRESULT CALLBACK WindowsEventProc(HWND hWindow,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_DESTROY:
		PostQuitMessage(0);
		break;

	case WM_LBUTTONDOWN:
		MessageBox(NULL,"Mysz wcisnieta","Komunikat",MB_OK);
		PostMessage(hWindow,WM_QUIT,NULL,NULL);
		break;

	case WM_CLOSE:
		char etykieta[255]="";
		GetWindowText(hWindow,etykieta,255);
		UINT wynik=MessageBox(hWindow,"Czy zamkn aplikacj?",etykieta,MB_YESNO);
		switch(wynik)
		{
			case IDYES:
				break;
			case IDNO:
				return 0;
		}
	}

	return DefWindowProc(hWindow,uMsg,wParam,lParam);
}

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE,LPSTR,int cmdShow)
{
	WNDCLASSEX klasaOkna;
	ZeroMemory(&klasaOkna,sizeof(WNDCLASSEX));
	klasaOkna.cbSize=sizeof(klasaOkna);
	klasaOkna.lpfnWndProc=WindowsEventProc;
	klasaOkna.lpszClassName=sKlasaOkna.c_str();
	klasaOkna.hCursor=LoadCursor(NULL,IDC_ARROW);
	klasaOkna.hIcon=LoadIcon(NULL,IDI_APPLICATION);
	klasaOkna.hbrBackground=(HBRUSH)COLOR_WINDOW;

	RegisterClassEx(&klasaOkna);

	HWND uchwytOkna = CreateWindowEx(
		NULL,
		sKlasaOkna.c_str(),
		"Nazwa okna",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		NULL,
		hInstance,
		NULL);
	ShowWindow(uchwytOkna,cmdShow);

	/*
	srand(static_cast<int>(time(NULL)));
	int i=rand()%10;
	char bufor[255]="";
	MessageBox(uchwytOkna,itoa(i,bufor,10),"Liczba losowa",MB_OK);
	*/

	MSG msgMessage;
	BOOL wynik;
	while(wynik=GetMessage(&msgMessage,NULL,0,0))
	{
		if(wynik==-1)
		{
			MessageBox(NULL,"Bd krytyczny!","Komunikat",MB_OK | MB_ICONERROR);
		}
		else
		{
			TranslateMessage(&msgMessage);
			DispatchMessage(&msgMessage);
		}
	}
	return static_cast<int>(msgMessage.wParam);
}