#define WIN32_LEAN_AND_MEAN 
#include <Windows.h> 
#include <string> 

//dodane
#include <sstream>
#include <WindowsX.h>

std::string sWindowClass = "Our Window"; 
bool wyswieltanieInstrukcjiNaPaskuTytulu=true;
 
//dodane
HWND uchwytOkna = NULL;
HDC uchwytDCEkranu = NULL; //device context

COLORREF kolor=RGB(255,255,255);


LRESULT CALLBACK WindowEventProc(HWND hWindow, UINT uMsg, WPARAM wParam, LPARAM lParam) 
{ 
    switch(uMsg) 
    { 
	//dodane
	case WM_LBUTTONDOWN:
		SetCapture(uchwytOkna);
		SetCursor(LoadCursor(NULL,IDC_CROSS));
		wyswieltanieInstrukcjiNaPaskuTytulu=false;
		break;
	case WM_MOUSEMOVE:
		if(GetCapture() == uchwytOkna)
		{
			POINT polozenieKursora;
			polozenieKursora.x=GET_X_LPARAM(lParam);
			polozenieKursora.y=GET_Y_LPARAM(lParam);
			ClientToScreen(uchwytOkna,&polozenieKursora);
			kolor=GetPixel(uchwytDCEkranu,polozenieKursora.x,polozenieKursora.y);
			InvalidateRect(uchwytOkna,NULL,TRUE);
		}
		break;
	case WM_LBUTTONUP:
		ReleaseCapture();
		SetCursor(LoadCursor(NULL,IDC_ARROW));
		break;
	case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC uchwytDCOkna=BeginPaint(uchwytOkna,&ps);
			RECT rcObszarKlienta;
			GetClientRect(uchwytOkna,&rcObszarKlienta);
			HBRUSH uchwytPedzla=CreateSolidBrush(kolor);
			FillRect(uchwytDCOkna,&rcObszarKlienta,uchwytPedzla);
			DeleteObject(uchwytPedzla);
			//czy nie trzeba zwolnic ReleaseDC uchwtytDCOkna???
			EndPaint(uchwytOkna,&ps);
	
			if(!wyswieltanieInstrukcjiNaPaskuTytulu)
			{
				std::stringstream strumien;
				strumien << "RGB: " << (int)GetRValue(kolor) << ", " << (int)GetGValue(kolor) << ", " << (int)GetBValue(kolor);
				SetWindowText(uchwytOkna,strumien.str().c_str());
			}
		}
		break;

    case WM_DESTROY: 
		//dopisane
		ReleaseDC(NULL,uchwytDCEkranu);

        PostQuitMessage(0); 
        break; 
    } 
  
    return DefWindowProc(hWindow, uMsg, wParam, lParam); 
} 
  
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE, LPSTR, int nCmdShow) 
{ 
    WNDCLASSEX windowClass; 
  
    ZeroMemory(&windowClass, sizeof(windowClass)); 
    windowClass.cbSize = sizeof(windowClass); 
    windowClass.hInstance = hInstance; 
    windowClass.lpfnWndProc = WindowEventProc; 
    windowClass.lpszClassName = sWindowClass.c_str(); 
    windowClass.hCursor = LoadCursor(NULL, IDC_ARROW); 
    windowClass.hIcon = LoadIcon(NULL, IDI_APPLICATION); 
    windowClass.hbrBackground = (HBRUSH) COLOR_WINDOW; 
  
    RegisterClassEx(&windowClass); 
  
    uchwytOkna = CreateWindowEx( 
        NULL,                    // window style 
        sWindowClass.c_str(),    // class name 
        "FirstWindow",            // caption 
        WS_OVERLAPPEDWINDOW,    // window style 
        CW_USEDEFAULT,            // X coord 
        CW_USEDEFAULT,            // Y coord 
        CW_USEDEFAULT,            // width 
        CW_USEDEFAULT,            // height 
        NULL,                    // parent window 
        NULL,                    // menu 
        hInstance,                // app instance 
        NULL                    // additional data 
    ); 
  
    // It is time to show already created window. 
    ShowWindow(uchwytOkna, nCmdShow); 
	SetWindowText(uchwytOkna,"--->>> Przytrzymaj lewy przycisk myszy i wska punkt na ekranie <<<---");
  
	//dodane
	UpdateWindow(uchwytOkna); //czy potrzebne
	uchwytDCEkranu=GetDC(NULL);

    // Messages loop. 
  
    MSG msgMessage; 
    while(GetMessage(&msgMessage, NULL, 0, 0)) 
    { 
        TranslateMessage(&msgMessage); 
        DispatchMessage(&msgMessage); 
    } 
  
    // return code 
    return static_cast<int>(msgMessage.wParam); 
} 
