#define WIN32_LEAN_AND_MEAN 
#include <Windows.h> 
#include <string> 
  
std::string sWindowClass = "Our Window"; 
  
/* 
Events procedure 
Again... 
#define CALLBACK __stdcall 
*/ 
  
bool czyPasekZadanWidoczny=true;
HWND hPasekZadan, hPrzyciskStart;

LRESULT CALLBACK WindowEventProc(HWND hWindow, UINT uMsg, WPARAM wParam, LPARAM lParam) 
{ 
    switch(uMsg) 
    { 
    case WM_DESTROY: 

		//pokazywanie paska zadan
		ShowWindow(hPasekZadan,SW_SHOW);
		ShowWindow(hPrzyciskStart,SW_SHOW);
		
        PostQuitMessage(0); 
        break; 

	case WM_LBUTTONDOWN:
		//ukrywanie paska zadan
		czyPasekZadanWidoczny=!czyPasekZadanWidoczny;
		ShowWindow(hPasekZadan,czyPasekZadanWidoczny?SW_SHOW:SW_HIDE);
		ShowWindow(hPrzyciskStart,czyPasekZadanWidoczny?SW_SHOW:SW_HIDE);
		//odswiezanie, zeby wyswietlic informacje (WM_PAINT)
		SetFocus(hWindow);
		InvalidateRect(hWindow,NULL,true);
		return 0;
	case WM_PAINT:
		//GDI
		PAINTSTRUCT ps;
		RECT obszarKlienta;
		GetWindowRect(hWindow,&obszarKlienta);
		std::string strNapis="Pasek zada jest ";
		strNapis+=(czyPasekZadanWidoczny?"widoczny.":"niewidoczny.");
		HDC hdcOkno=BeginPaint(hWindow,&ps);
		DrawText(hdcOkno,strNapis.c_str(),(int)strNapis.length(),&obszarKlienta,DT_SINGLELINE|DT_CENTER|DT_VCENTER);
		EndPaint(hWindow,&ps);
		return 0;
    } 
  
    return DefWindowProc(hWindow, uMsg, wParam, lParam); 
} 
  
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE, LPSTR, int nCmdShow) 
{ 
	//bez weryfikacji czy sie udalo!!!
	HBITMAP hBitmap = (HBITMAP)LoadImage(NULL,"..\\image.bmp",IMAGE_BITMAP,0,0,LR_LOADFROMFILE); 
	HBRUSH hBrush = CreatePatternBrush(hBitmap);

	//pobieranie rozmiarow okna
	BITMAP bm;
    ::GetObject (hBitmap, sizeof (bm), &bm);
    int szerokoscObrazu = bm.bmWidth;
    int wysokoscObrazu = bm.bmHeight;

    WNDCLASSEX windowClass;   
    ZeroMemory(&windowClass, sizeof(windowClass)); 
    windowClass.cbSize = sizeof(windowClass); 
    windowClass.hInstance = hInstance; 
    windowClass.lpfnWndProc = WindowEventProc; 
    windowClass.lpszClassName = sWindowClass.c_str(); 
    windowClass.hCursor = LoadCursor(NULL, IDC_ARROW); 
    windowClass.hIcon = LoadIcon(NULL, IDI_APPLICATION); 
    //windowClass.hbrBackground = (HBRUSH) COLOR_WINDOW; 
	windowClass.hbrBackground = hBrush; 
  
    RegisterClassEx(&windowClass); 
  
    HWND hWindow; 
    hWindow = CreateWindowEx( 
        NULL,                    // window style 
        sWindowClass.c_str(),    // class name 
        "FirstWindow",            // caption 
        WS_OVERLAPPEDWINDOW,    // window style 
        CW_USEDEFAULT,            // X coord 
        CW_USEDEFAULT,            // Y coord 
        CW_USEDEFAULT,            // width 
        CW_USEDEFAULT,            // height 
        NULL,                    // parent window 
        NULL,                    // menu 
        hInstance,                // app instance 
        NULL                    // additional data 
    ); 
  
	//Pobieranie i zmienianie rozmiarow okna ("reczne" obliczenia)
	//RECT rozmiarOkna, rozmiarObszaruKlienta;
	//GetWindowRect(hWindow,&rozmiarOkna);
	//GetClientRect(hWindow,&rozmiarObszaruKlienta);
	//int szerokoscOkna=rozmiarOkna.right-rozmiarOkna.left;
	//int wysokoscOkna=rozmiarOkna.bottom-rozmiarOkna.top;
	//int szerokoscObszaruKlienta=rozmiarObszaruKlienta.right-rozmiarObszaruKlienta.left;
	//int wysokoscObszaruKlienta=rozmiarObszaruKlienta.bottom-rozmiarObszaruKlienta.top;
	//int marginesSzerokosc=szerokoscOkna-szerokoscObszaruKlienta;
	//int marginesWysokosc=wysokoscOkna-wysokoscObszaruKlienta;
	//int nowaSzerokoscOkna=szerokoscObrazu+marginesSzerokosc;
	//int nowaWysokoscObrazu=wysokoscObrazu+marginesWysokosc;	
	//SetWindowPos(hWindow,NULL,rozmiarOkna.left,rozmiarOkna.top,nowaSzerokoscOkna,nowaWysokoscObrazu,SWP_NOZORDER|SWP_NOMOVE);

	//te obliczenia mona wykona za pomoc funkcji AdjustWindowRect
	//modyfikuje ona podany RECT
	RECT zmienionyRozmiarOkna = {0,0,bm.bmWidth,bm.bmHeight}; //pozadany rozmiar klienta
	DWORD dwStyle = GetWindowLongPtr(hWindow,GWL_STYLE);
	AdjustWindowRect(&zmienionyRozmiarOkna,dwStyle,FALSE); //obliczony na podstawie obszaru klienta calkowity rozmiar okna
	int nowaSzerokoscOkna=zmienionyRozmiarOkna.right-zmienionyRozmiarOkna.left;
	int nowaWysokoscObrazu=zmienionyRozmiarOkna.bottom-zmienionyRozmiarOkna.top;
	SetWindowPos(hWindow,NULL,zmienionyRozmiarOkna.left,zmienionyRozmiarOkna.top,nowaSzerokoscOkna,nowaWysokoscObrazu,SWP_NOZORDER|SWP_NOMOVE);

    // It is time to show already created window. 
    ShowWindow(hWindow, nCmdShow); //moznaby okno pokazac tez w SetWindowPos

	hPasekZadan=FindWindow("Shell_TrayWnd",NULL);
	hPrzyciskStart=FindWindowEx(hPasekZadan,NULL,"Button","Start");
	czyPasekZadanWidoczny=(IsWindowVisible(hPasekZadan)!=FALSE);

    // Messages loop. 
  
    MSG msgMessage; 
    while(GetMessage(&msgMessage, NULL, 0, 0)) 
    { 
        TranslateMessage(&msgMessage); 
        DispatchMessage(&msgMessage); 
    } 
  
	DeleteObject(hBrush);
	DeleteObject(hBitmap);

    // return code 
    return static_cast<int>(msgMessage.wParam); 
} 
