﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Windows.Foundation;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Data;
using Windows.Storage;
using Windows.Storage.Pickers;
using System.Xml;
using Windows.Data.Xml.Dom;
using Windows.UI.Notifications;

namespace player
{
    partial class MainPage
    {
        public List<song> Playlist;
        int playingNumber = -1;

        public MainPage()
        {
            InitializeComponent();
            //inicjujemy playliste
            Playlist = new List<song>();
        }
        /// <summary>
        /// Ddoawanie piosenki dla playlisty
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private async void AddButton_Click(object sender, RoutedEventArgs e)
        {
            //FileOpenPicker-Klasa do obslugi dodawania plikow-oczywiscie w stylu metro :)
            FileOpenPicker fop = new FileOpenPicker();
            //ustawiamy fodler poczatkowy
            fop.SuggestedStartLocation = PickerLocationId.Desktop;
            //ustawiamy, jakie pliki maja byc widoczne
            fop.FileTypeFilter.Add(".mp3");
            //uruchamiamy pickera
            var files = await fop.PickMultipleFilesAsync();
            //iterujemy po liscie otrzymanych plikow
            foreach (var file in files)
            {
                //pobieramy dane o utworze z pliku
                var properties = await file.Properties.GetMusicPropertiesAsync();
                //dodajemy obiekt piosenki do playlisty
                Playlist.Add(new song(file) { File = file, Duration = properties.Duration, Name = file.Name });
                //dodajemy go do listobxa reprezentujacego playliste
                PlaylistListBox.Items.Add(file.Name);
            }
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            if (playingNumber == -1 && Playlist.Count > 0)
            {
                playingNumber = 0;
                SetMediaElementSourceAsync(Playlist[0].File);
                ShowMessage("Now playing: " + Playlist[playingNumber].Name);
                updateTile(Playlist[playingNumber].Name);
            }
        }

        async Task SetMediaElementSourceAsync(StorageFile file)
        {
            var stream = await file.OpenAsync(Windows.Storage.FileAccessMode.Read);
            Player.SetSource(stream, file.ContentType);
        }
        /// <summary>
        /// zmiana piosenki po zakonczeniu odtwarzania potrzebnej
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Player_MediaEnded(object sender, RoutedEventArgs e)
        {
            if (playingNumber < Playlist.Count)
            {
                playingNumber++;
                SetMediaElementSourceAsync(Playlist[playingNumber].File);
                ShowMessage("Now playing: " + Playlist[playingNumber].Name);
                updateTile(Playlist[playingNumber].Name);
            }
        }

        /// <summary>
        /// Metoda do pokazywania notyfikacji. Ich wyglad deklarowany jest poprzez XMLa
        /// </summary>
        /// <param name="tekst"></param>
        private void ShowMessage(string tekst)
        {
            //ustawiamy szablon notyfikacji
            XmlDocument toastXml = ToastNotificationManager.GetTemplateContent(ToastTemplateType.ToastText02);
            IXmlNode listaWezlow = toastXml.GetElementsByTagName("text").First();
            //ustawiamy tekst
            listaWezlow.AppendChild(toastXml.CreateTextNode(tekst));
            //tworzymy notyfikacje na pdostawie XMLa
            ToastNotification toast = new ToastNotification(toastXml);
            //pokazujemy notyfikacje
            ToastNotificationManager.CreateToastNotifier().Show(toast);
        }
        /// <summary>
        /// Metoda wyswietlajaca na kafelku informacje o aktualnie odtwarzanym utworze. Dziala tak smao jak w aplikacji kolory
        /// </summary>
        /// <param name="title"></param>
        public void updateTile(string title)
        {
            TileUpdater tu = TileUpdateManager.CreateTileUpdaterForApplication();
            XmlDocument xml = TileUpdateManager.GetTemplateContent(TileTemplateType.TileWideText01);
            IXmlNode wezelTekst = xml.GetElementsByTagName("text").First();
            wezelTekst.AppendChild(xml.CreateTextNode("Now playing:"));
            wezelTekst = xml.GetElementsByTagName("text").Item(1);
            wezelTekst.AppendChild(xml.CreateTextNode(title));
            tu.Update(new TileNotification(xml));
        }
        /// <summary>
        /// zmiana piosenki po kliknieciu na nia na playliscie
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void PlaylistListBox_DoubleTapped(object sender, Windows.UI.Xaml.Input.DoubleTappedEventArgs e)
        {
            int i = PlaylistListBox.SelectedIndex;
            if (i >= 0 && i < Playlist.Count)
            {
                if (playingNumber == -1 && Playlist.Count > 0)
                    playingNumber = 0;
                SetMediaElementSourceAsync(Playlist[i].File);
                ShowMessage("Now playing: " + Playlist[playingNumber].Name);
                updateTile(Playlist[playingNumber].Name);
            }
        }
    }
}
