﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Windows.Foundation;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Data;
using Windows.Media;
using Windows.UI.Xaml.Media;
using System.Xml;
using Windows.UI.Notifications;
using Windows.Data.Xml.Dom;

namespace kolory
{
    partial class MainPage
    {
        public MainPage()
        {
            InitializeComponent();
        }
        /// <summary>
        /// metoda zwracajaca skaldowe RGB koloru
        /// </summary>
        /// <param name="kolor"></param>
        /// <returns></returns>
        private static string SkładoweKoloruDec(Color kolor)
        {
            return "R=" + kolor.R.ToString() + ", G=" + kolor.G.ToString() + ", B=" + kolor.B.ToString() + ", A=" + kolor.A.ToString();
        }
        //TileUpdater-klasa, ktorej instancja daje nam mozliwosc zmiany wygladu kafelka w czasie dzialania aplikacji
        TileUpdater tu = TileUpdateManager.CreateTileUpdaterForApplication();
        /// <summary>
        /// Metoda zmieniajaca wyglad kafelka. Do opisu wygladu kafelka uzywamy XMLa
        /// </summary>
        /// <param name="kolor"></param>
        public void zmienWygladKafelka(Color kolor)
        {
            XmlDocument xml = TileUpdateManager.GetTemplateContent(TileTemplateType.TileWideText01);
            IXmlNode wezelTekst = xml.GetElementsByTagName("text").First();
            wezelTekst.AppendChild(xml.CreateTextNode("Kolory:"));
            wezelTekst = xml.GetElementsByTagName("text").Item(1);
            wezelTekst.AppendChild(xml.CreateTextNode(SkładoweKoloruDec(kolor)));
            tu.Update(new TileNotification(xml));
        }

        /// <summary>
        /// Metoda zmieniajaca kolor panelu
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Slider_ValueChanged(object sender, RoutedPropertyChangedEventArgs e)
        {
            Color color = new Color()
            {
                R = (byte)Slider1.Value,
                G = (byte)Slider2.Value,
                B = (byte)Slider3.Value,
                A = (byte)100
            };
            (Rectangle1.Fill as SolidColorBrush).Color = color;
            
        }
        //Metoda, ktora na klikniecie buttona aktualizuje wyglad kafelka
        private void Button_Click(object sender, RoutedEventArgs e)
        {
            Color color = new Color()
            {
                R = (byte)Slider1.Value,
                G = (byte)Slider2.Value,
                B = (byte)Slider3.Value,
                A = (byte)100
            };
            zmienWygladKafelka(color);
        }
    }
}
