
// DirectSoundDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DirectSoundDemo.h"
#include "DirectSoundDemoDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CDirectSoundDemoDlg dialog

CDirectSoundDemoDlg::CDirectSoundDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CDirectSoundDemoDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_Dzwiek = NULL;
}

void CDirectSoundDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO1, comboBox1);
	DDX_Control(pDX, IDC_EDIT1, edit1);
}

BEGIN_MESSAGE_MAP(CDirectSoundDemoDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, &CDirectSoundDemoDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CDirectSoundDemoDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CDirectSoundDemoDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CDirectSoundDemoDlg::OnBnClickedButton4)
	ON_CBN_SELCHANGE(IDC_COMBO1, &CDirectSoundDemoDlg::OnCbnSelchangeCombo1)
END_MESSAGE_MAP()


// CDirectSoundDemoDlg message handlers

BOOL CDirectSoundDemoDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	//dodane recznie
	if(FAILED(DirectSoundEnumerate(UrzadzenieAudio::EnumUrzadzeniaAudio,&urzadzeniaAudio)))
	{		
		edit1.SetWindowText("Nie znaleziono urzdze audio");
	}
	for(unsigned int i=0;i<urzadzeniaAudio.size();i++)
	{
		comboBox1.AddString(urzadzeniaAudio[i]->opis.c_str());
	}
	comboBox1.SetCurSel(0);
	biezaceUrzadzenie=new UrzadzenieAudio;
	biezaceUrzadzenie->opis=urzadzeniaAudio[0]->opis;
	biezaceUrzadzenie->guid=urzadzeniaAudio[0]->guid;
	biezaceUrzadzenie->modul=urzadzeniaAudio[0]->modul;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDirectSoundDemoDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDirectSoundDemoDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


//Wczytaj
void CDirectSoundDemoDlg::OnBnClickedButton1()
{
	CFileDialog fileDialog(TRUE,"*.*",NULL,OFN_HIDEREADONLY,"Wav files (*.wav)|*.wav||");
	if(fileDialog.DoModal()==IDOK)
	{
		CString sciezkaPliku=fileDialog.GetPathName();
		edit1.SetWindowText(sciezkaPliku);
		char* wsk=sciezkaPliku.GetBuffer(sciezkaPliku.GetLength());
		sciezkaPliku.ReleaseBuffer();

		m_Dzwiek=new Dzwiek;
		if(!m_Dzwiek) return;

		HWND uchwytOkna=this->m_hWnd;

		bool wynik=m_Dzwiek->Inicjacja(uchwytOkna,wsk,biezaceUrzadzenie);
		if(!wynik)
		{
			edit1.SetWindowText("Inicjacja nie powioda si!");
		}
	} 
}

//Odtwarzaj
void CDirectSoundDemoDlg::OnBnClickedButton2()
{
	if(m_Dzwiek==NULL) return;
	if(!m_Dzwiek->czyWstrzymane) m_Dzwiek->Odtwarzaj();
	else if(!m_Dzwiek->czyZatrzymane) m_Dzwiek->Wznow();
	edit1.SetWindowText("Odtwarzanie");
}

//Pauza
void CDirectSoundDemoDlg::OnBnClickedButton3()
{
	if(m_Dzwiek==NULL) return;
	if(!m_Dzwiek->czyWstrzymane) 
	{
		m_Dzwiek->Wstrzymaj();
		edit1.SetWindowText("Pauza");
	}
	else if(!m_Dzwiek->czyZatrzymane) 
	{
		m_Dzwiek->Wznow();
		edit1.SetWindowText("Odtwarzanie");
	}
	
}

//Zatrzymaj
void CDirectSoundDemoDlg::OnBnClickedButton4()
{
	if(m_Dzwiek==NULL) return;
	if(!m_Dzwiek->czyZatrzymane) m_Dzwiek->Zatrzymaj();
	edit1.SetWindowText("Zatrzymane");
}

void CDirectSoundDemoDlg::OnCbnSelchangeCombo1()
{
	biezaceUrzadzenie->opis=urzadzeniaAudio[comboBox1.GetCurSel()]->opis;
	biezaceUrzadzenie->guid=urzadzeniaAudio[comboBox1.GetCurSel()]->guid;
	biezaceUrzadzenie->modul=urzadzeniaAudio[comboBox1.GetCurSel()]->modul;
}
