#include "Dzwiek.h"

BOOL CALLBACK UrzadzenieAudio::EnumUrzadzeniaAudio(LPGUID guid, LPCSTR opis, LPCSTR modul, LPVOID lista)
{
	UrzadzenieAudio* audio=new UrzadzenieAudio();
	if(guid == NULL) audio->guid=NULL;
	else
	{
		audio->guid=new GUID;
		memcpy(audio->guid,guid,sizeof(GUID));
	}
	audio->opis=opis;
	audio->modul=modul;
	(static_cast<UrzadzeniaAudio*>(lista))->push_back(audio);
	return true;
}

UrzadzenieAudio::UrzadzenieAudio()
{
	guid=NULL;
}

UrzadzenieAudio::~UrzadzenieAudio()
{
	delete guid;
}

Dzwiek::Dzwiek()
{
	m_DirectSound = 0;
	m_buforGlowny = 0;
	m_buforDrugorzedny = 0;
}

/*
Dzwiek::~Dzwiek()
{
}
*/

bool Dzwiek::Inicjacja(HWND uchwytOkna, char* sciezka, UrzadzenieAudio* urzadzenieAudio)
{
	bool wynik = InicjujDirectSound(uchwytOkna, urzadzenieAudio);
	if(!wynik) return false;

	wynik = WczytajPlikWave(sciezka, &m_buforDrugorzedny);
	if(!wynik) return false;

	czyWstrzymane = false;
	czyZatrzymane = false;

	return true;
}

void Dzwiek::Zamknij()
{
	ZamknijPlikWave(&m_buforDrugorzedny);
	ZamknijDirectSound();
	return;
}

bool Dzwiek::InicjujDirectSound(HWND uchwytOkna, UrzadzenieAudio* urzadzenieAudio)
{
	HRESULT wynik=DirectSoundCreate8(urzadzenieAudio->guid, &m_DirectSound,NULL);
	if(FAILED(wynik)) return false;

	wynik=m_DirectSound->SetCooperativeLevel(uchwytOkna,DSSCL_PRIORITY);
	if(FAILED(wynik)) return false;

	DSBUFFERDESC opisBufora;
	opisBufora.dwSize=sizeof(DSBUFFERDESC);
	opisBufora.dwFlags=DSBCAPS_PRIMARYBUFFER | DSBCAPS_CTRLVOLUME;
	opisBufora.dwBufferBytes=0;
	opisBufora.dwReserved=0;
	opisBufora.lpwfxFormat=NULL;
	opisBufora.guid3DAlgorithm=GUID_NULL;

	wynik=m_DirectSound->CreateSoundBuffer(&opisBufora,&m_buforGlowny,NULL);
	if(FAILED(wynik)) return false;

	//parametry konkretnego pliku
	WAVEFORMATEX formatWave;	
	formatWave.wFormatTag=WAVE_FORMAT_PCM;
	formatWave.nSamplesPerSec=44100; //czestosc probkowania
	formatWave.wBitsPerSample=16; //jakosc dzwieku
	formatWave.nChannels=2; //stereo
	formatWave.cbSize=0;
	formatWave.nBlockAlign=(formatWave.wBitsPerSample/8)*formatWave.nChannels;
	formatWave.nAvgBytesPerSec=formatWave.nSamplesPerSec*formatWave.nBlockAlign;

	wynik=m_buforGlowny->SetFormat(&formatWave);
	if(FAILED(wynik)) return false;

	return true;
}

void Dzwiek::ZamknijDirectSound()
{
	if(m_buforGlowny)
	{
		m_buforGlowny->Release();
		m_buforGlowny=0;
	}

	if(m_DirectSound)
	{
		m_DirectSound->Release();
		m_DirectSound=0;
	}

	return;
}

bool Dzwiek::WczytajPlikWave(char* sciezka,IDirectSoundBuffer8** buforDrugorzedny)
{
	FILE* wskPlik = fopen(sciezka,"rb");
	if(wskPlik == NULL) return false;

	NaglowekWave naglowek;
	unsigned int licznik = fread(&naglowek,sizeof(naglowek),1,wskPlik);
	if(licznik!=1) return false;

	if(strncmp(naglowek.chunkID,"RIFF",4)!=0) return false;
	if(strncmp(naglowek.format,"WAVE",4)!=0) return false;
	if(strncmp(naglowek.subChunkID,"fmt ",4)!=0) return false;
	if(strncmp(naglowek.dataChunkID,"data",4)!=0) return false;
	
	if(naglowek.audioFormat!=WAVE_FORMAT_PCM) return false;
	if(naglowek.numChannels!=2) return false;
	if(naglowek.sampleRate!=44100) return false;
	if(naglowek.bitsPerSample!=16) return false;

	
	WAVEFORMATEX formatWave;	
	formatWave.wFormatTag=WAVE_FORMAT_PCM;
	formatWave.nSamplesPerSec=44100; //czestosc probkowania
	formatWave.wBitsPerSample=16; //jakosc dzwieku
	formatWave.nChannels=2; //stereo
	formatWave.cbSize=0;
	formatWave.nBlockAlign=(formatWave.wBitsPerSample/8)*formatWave.nChannels;
	formatWave.nAvgBytesPerSec=formatWave.nSamplesPerSec*formatWave.nBlockAlign;

	DSBUFFERDESC opisBufora;
	opisBufora.dwSize=sizeof(DSBUFFERDESC);
	opisBufora.dwFlags=DSBCAPS_CTRLVOLUME | DSBCAPS_GLOBALFOCUS;
	opisBufora.dwBufferBytes=naglowek.dataSize;
	opisBufora.dwReserved=0;
	opisBufora.lpwfxFormat=&formatWave;
	opisBufora.guid3DAlgorithm=GUID_NULL;

	//tworzenie tymczasowego bufora do sprawdzenia, czy wszystko jest OK
	IDirectSoundBuffer* buforTmp;
	HRESULT wynik = m_DirectSound->CreateSoundBuffer(&opisBufora,&buforTmp,NULL);
	if(FAILED(wynik)) return false;
	wynik=buforTmp->QueryInterface(IID_IDirectSoundBuffer8,(void**)&*buforDrugorzedny);
	if(FAILED(wynik)) return false;
	buforTmp->Release();
	buforTmp=0;

	fseek(wskPlik,sizeof(NaglowekWave),SEEK_SET);
	unsigned char* daneWave = new unsigned char[naglowek.dataSize];
	if(!daneWave) return false;
	
	licznik=fread(daneWave,1,naglowek.dataSize,wskPlik);
	if(licznik!=naglowek.dataSize) return false;

	int blad = fclose(wskPlik);
	if (blad!=0) return false;

	//przygotowanie do kopiowania (blokowanie) i kopiowanie 
	unsigned char* wskBufor;
	unsigned long rozmiarBufora;	
	wynik=(*buforDrugorzedny)->Lock(0,naglowek.dataSize,(void**)&wskBufor,(DWORD*)&rozmiarBufora,NULL,0,0); //jest mozliwosc podania wskaznika na kolejna porcje
	if(FAILED(wynik)) return false;
	memcpy(wskBufor,daneWave,naglowek.dataSize); //kopiowanie danych do bufora (wszystko w jednym kawalku)
	wynik = (*buforDrugorzedny)->Unlock((void*)wskBufor,rozmiarBufora,NULL,0); //zwalnianie blokady (unlock)
	delete [] daneWave;
	daneWave = NULL;

	return true;
}

void Dzwiek::ZamknijPlikWave(IDirectSoundBuffer8** buforDrugorzedny)
{
	if(*buforDrugorzedny)
	{
		(*buforDrugorzedny)->Release();
		*buforDrugorzedny=NULL;
	}
}

bool Dzwiek::Odtwarzaj()
{
	HRESULT wynik = m_buforDrugorzedny->SetCurrentPosition(0);
	if(FAILED(wynik)) return false;

	wynik=m_buforDrugorzedny->SetVolume(DSBVOLUME_MAX);
	if(FAILED(wynik)) return false;

	wynik=m_buforDrugorzedny->Play(0,0,0);
	if(FAILED(wynik)) return false;

	czyZatrzymane = false;
	return true;
}

bool Dzwiek::Wznow()
{
	HRESULT wynik=m_buforDrugorzedny->Play(0,0,0);
	if(FAILED(wynik)) return false;

	czyWstrzymane = false;
	return true;
}

bool Dzwiek::Zatrzymaj()
{
	if(!czyWstrzymane)
	{
		HRESULT wynik=m_buforDrugorzedny->Stop();
		if(FAILED(wynik)) return false;
	}
	czyZatrzymane=true;
	czyWstrzymane=false;	
	
	return true;
}

bool Dzwiek::Wstrzymaj()
{
	HRESULT wynik=m_buforDrugorzedny->Stop();
	if(FAILED(wynik)) return false;
	if(!czyZatrzymane) czyWstrzymane=true;
	
	return true;
}