#include <windows.h>
#include <sphelper.h>

#pragma warning(disable:4995)
#include <iostream>

bool done=false;

BOOL WINAPI HandlerRoutine(DWORD dwCtrlType)
{
	std::wcout<< "Koniec ... " << std::endl;
	done=true;
	return TRUE;
}

int wmain(int argc, wchar_t **argv)
{
	const USHORT MY_MAX_ALTERNATES = 10;
	//tu bdzie rozpoznany tekst
	LPWSTR pwszText;
	//uchwyt do zdarzenia
	HRESULT hr;
	//zdarzenie rozpoznania, nie rozpoznania tekstu przez niego zwracane s wyniki
	CSpEvent evt;
	//contains information about speech recognition information, including hypotheses, false recognitions, recognitions, and alternate recognitions.
	SPPHRASE *pParts;
	ISpPhrase *pPhrase;
	//informacje o interesujcych nas zdarzeniach
	ULONGLONG ullEvents;
	//CComPtr - A smart pointer class for managing COM interface pointers.
	CComPtr<ISpRecognizer> cpEngine;
	CComPtr<ISpRecoContext> cpRecoCtx;
	CComPtr<ISpRecoGrammar> cpGram;
	//alternatywne rozpoznania
	CComPtr<ISpPhraseAlt> pcpPhraseAlt[MY_MAX_ALTERNATES];
	//ilosc alternatywnych rozwiza do wywietlenia
	ULONG ulCount;

		
		SetConsoleCtrlHandler(HandlerRoutine,TRUE);
		CoInitialize(0);

		//hr=cpEngine.CoCreateInstance(CLSID_SpSharedRecognizer);
		hr=cpEngine.CoCreateInstance(CLSID_SpInprocRecognizer);
		// create default audio object
		CComPtr<ISpAudio> cpAudio;
		//SPCAT_AUDIOIN -  default audio input token.
		SpCreateDefaultObjectFromCategoryId(SPCAT_AUDIOIN, &cpAudio);
		// set the input for the engine, true zmieniaj do preferowanego formatu stream
		if (SUCCEEDED(hr))
		{
			cpEngine->SetInput(cpAudio, TRUE);
		}
		//SPRST_ACTIVE
        /*
		SPRST_ACTIVE 
		This state is the default and indicates that recognition will take place if there are any active rules. 
		If a rule is active, audio will be read and passed to the SR engine and recognition will happen.*/
		if (SUCCEEDED(hr))
		{
			hr =cpEngine->SetRecoState( SPRST_ACTIVE );
		}
		if (SUCCEEDED(hr))
		{
			hr=cpEngine->CreateRecoContext(&cpRecoCtx);
		}
		/*SetNotifyWin32Event sets up a Win32 event object to be used by this instance for notifications. 
		The event handle can be retrieved through GetNotifyEventHandle.*/
		if (SUCCEEDED(hr))
		{
			hr=cpRecoCtx->SetNotifyWin32Event();
		}
		//interesuja nas zdarzenia rozpoznania i nie rozpoznania sowa
		ullEvents=SPFEI(SPEI_RECOGNITION) | SPFEI(SPEI_FALSE_RECOGNITION);
		if (SUCCEEDED(hr))
		{
			hr=cpRecoCtx->SetInterest(ullEvents,ullEvents);
		}

	if ( argc < 2)
	{
		std::wcout<<"Modu dictation"<<std::endl;
		if (SUCCEEDED(hr))
		{
			hr=cpRecoCtx->CreateGrammar(1,&cpGram);
		}
		//SPTOPIC_SPELLING
		if (SUCCEEDED(hr))
		{
			hr=cpGram->LoadDictation(NULL,SPLO_STATIC);
		}
		if (SUCCEEDED(hr))
		{
			hr=cpGram->SetDictationState(SPRS_ACTIVE);
		}
	}
	else if(argc==2)
	{
		std::wcout<<"Korzystam z podanych regu"<<std::endl;
		if (SUCCEEDED(hr))
		{
			hr=cpRecoCtx->CreateGrammar(1,&cpGram);
		}
		if (SUCCEEDED(hr))
		{
			hr=cpGram->LoadCmdFromFile(argv[1], SPLO_STATIC);
		}
		if (SUCCEEDED(hr))
		{
			hr=cpGram->SetRuleState(0,0,SPRS_ACTIVE);
		}
	}
		
		
		while (!done)
		{
			while(evt.GetFrom(cpRecoCtx)==S_OK)
			{
				switch(evt.eEventId)
				{

				case SPEI_RECOGNITION: 
					{
						pPhrase = evt.RecoResult();
						if (SUCCEEDED(hr))
						{
							hr=pPhrase->GetPhrase(&pParts);
						}
						if (SUCCEEDED(hr))
						{
							hr=pPhrase->GetText(SP_GETWHOLEPHRASE,SP_GETWHOLEPHRASE,FALSE,&pwszText,0);
						}
						std::wcout<<pwszText<<" ("<<pParts->Rule.Confidence<<")"<<std::endl;
						
						//alternatywne wersje
						if (SUCCEEDED(hr))
						{
							hr=evt.RecoResult()->GetAlternates(pParts->Rule.ulFirstElement,
							pParts->Rule.ulCountOfElements,
							MY_MAX_ALTERNATES,
							(ISpPhraseAlt**)pcpPhraseAlt,
							&ulCount);
						}
						 for (int i = 0; i < ulCount; i++)
						{
							if (SUCCEEDED(hr))
							{
								hr = pcpPhraseAlt[i]->GetText(SP_GETWHOLEPHRASE, SP_GETWHOLEPHRASE, FALSE, &pwszText, NULL);
							}
							std::wcout<<"(Alternative): "<<pwszText<<std::endl;
						 }
						CoTaskMemFree(pParts);
						CoTaskMemFree(pwszText);

					}
					break;
				case SPEI_FALSE_RECOGNITION:
					std::wcout<<"Nie wiem o co ci chodzi"<<std::endl;
				}
			}
		}

		cpGram.Release();
		cpRecoCtx.Release();
		cpEngine.Release();

		CoUninitialize();
	
	return 0;
}