//---------------------------------------------------------------------------

#ifndef MediaPlayerH
#define MediaPlayerH
//---------------------------------------------------------------------------

#include <windows.h>
#include <mmsystem.h>
#include <ComCtrls.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>

typedef enum {smpNiezainicjowany=-1, smpZatrzymany=0, smpOdtwarzanie=1, smpPauza=2} StanMediaPlayer;

class MediaPlayer
{
    private:
        AnsiString sciezkaPliku;
        StanMediaPlayer stan;

        void UstawFormatCzasu() //milisekundy
        {
                AnsiString polecenie = "set " + sciezkaPliku + " time format milliseconds";
                mciSendString(polecenie.c_str(),NULL,0,0);
        }

    public:
        AnsiString SciezkaPliku()
        {
                return sciezkaPliku;
        }

        StanMediaPlayer Stan()
        {
                return stan;
        }

        AnsiString OpisStanu()
        {
                AnsiString wynik="";
                switch(stan)
                {
                        case smpNiezainicjowany: wynik="Niezainicjowany"; break;
                        case smpZatrzymany: wynik="Zatrzymany"; break;
                        case smpOdtwarzanie: wynik="Odtwarzanie"; break;
                        case smpPauza: wynik="Pauza"; break;
                        default: wynik="Bd!"; break;
                }
                return wynik;
        }

        MediaPlayer(AnsiString sciezkaPliku="",bool odtwarzaj=false)
                :stan(smpNiezainicjowany)
        {
                if(!sciezkaPliku.IsEmpty())
                {
                        Wczytaj(sciezkaPliku);
                        if(odtwarzaj)
                        {
                                Odtwarzaj();
                        }
                }
        }

        void Wczytaj(AnsiString sciezkaPliku)
        {
                this->sciezkaPliku="\""+sciezkaPliku+"\""; //dodanie cudzyslowow
                AnsiString polecenie = "open " + this->sciezkaPliku + " type mpegvideo";
                mciSendString(polecenie.c_str(),NULL,0,0);
                UstawFormatCzasu();
                stan=smpZatrzymany;
        }

        void Zamknij()
        {
                AnsiString polecenie = "close " + sciezkaPliku;
                mciSendString(polecenie.c_str(),NULL,0,0);
                stan=smpNiezainicjowany;
        }

        void Odtwarzaj()
        {
                AnsiString polecenie = "play " + sciezkaPliku;
                mciSendString(polecenie.c_str(),NULL,0,0);
                stan=smpOdtwarzanie;
        }

        void Pauza()
        {
                AnsiString polecenie = "stop " + sciezkaPliku;
                mciSendString(polecenie.c_str(),NULL,0,0);
                stan=smpPauza;
        }

        void OdtwarzajOdPozycji(int pozycja)
        {
                AnsiString polecenie = "play " + sciezkaPliku + " from " + pozycja;
                mciSendString(polecenie.c_str(),NULL,0,0);
                stan=smpOdtwarzanie;
        }

        int Dlugosc()
        {
                char sdlg[128];
                AnsiString polecenie = "status " + sciezkaPliku + " length";
                mciSendString(polecenie.c_str(),sdlg,128,0);
                int dlg=atoi(sdlg);
                return dlg;
        }

        void UstawGlosnosc(int vol)
        {
                AnsiString polecenie="setaudio "+ sciezkaPliku + " volume to " + vol;
                mciSendString(polecenie.c_str(),NULL,0,0);
        }

        int Pozycja()
        {
                char spoz[128];
                AnsiString polecenie = "status " + sciezkaPliku + " position";
                mciSendString(polecenie.c_str(),spoz,128,0);
                int poz=atoi(spoz);
                return poz;
        }
};


#endif
