#include "Okno.h"
#include "resource.h"

/*
void ShowMessage(LPCSTR Text)
{
	MessageBox(NULL,Text,"",NULL);
}
*/

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
	POINT polozenieOkna={100,100};
	POINT rozmiarOkna={800,600};	
	if (!okno.Init(hInstance,polozenieOkna,rozmiarOkna))
	{
		MessageBox(NULL,"Inicjacja okna nie powioda si","Aplikacja Win32",MB_OK | MB_ICONERROR);
		return EXIT_FAILURE;
	}
	else return okno.Run();
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	return okno.WndProc(hWnd,message,wParam,lParam);
}

bool COkno::Init(HINSTANCE uchwytAplikacji,POINT polozenieOkna,POINT rozmiarOkna)
{
	char nazwaOkna[]="Aplikacja Win32";

	//WNDCLASSEX wc;
	wc.cbSize=sizeof(wc);
	wc.style= CS_HREDRAW | CS_VREDRAW | CS_OWNDC; //styl okna
	wc.lpfnWndProc= (WNDPROC)::WndProc; //procedura okna
	wc.cbClsExtra= 0; //dodatkowe bajty zarezerwowane za klas okna
	wc.cbWndExtra= 0; //dodatkowe bajty zarezerwowane za instancj okna
	wc.hInstance= uchwytAplikacji; //instancja aplikacji
	wc.hIcon= LoadIcon(uchwytAplikacji,MAKEINTRESOURCE(IDI_ICON1)); //uchwyt ikony
	wc.hIconSm= LoadIcon(uchwytAplikacji,MAKEINTRESOURCE(IDI_ICON1)); //uchwyt ikony
	wc.hCursor= LoadCursor(NULL, IDC_ARROW); //uchwyt kursora
	wc.hbrBackground= (HBRUSH)(COLOR_WINDOW+1); //uchwyt pdzla ta
	wc.lpszMenuName= NULL; //nazwa menu
	wc.lpszClassName= nazwaOkna; //nazwa klasy okna	

	//Rejestracja klasy okna
	if(RegisterClassEx(&wc)==0) return false;

	//ustawienia dla okna
	DWORD stylOkna=WS_OVERLAPPEDWINDOW;

	//Tworzenie okna
	uchwytOkna = CreateWindow(
		nazwaOkna, //nazwa klasy okna
		nazwaOkna, //nazwa okna
		stylOkna,
		polozenieOkna.x,polozenieOkna.y, //pooenie okna (x,y)
		rozmiarOkna.x,rozmiarOkna.y, //rozmiar okna (szeroko, wysoko)
		NULL, //uchwyt okna nadrzdnego (parent)
		NULL, //uchwyt menu
		uchwytAplikacji, //uchwyt instancji aplikacji
		NULL //parametr komunikatu informujacego o utworzeniu okna
	);

	if(uchwytOkna==NULL) return false;

	//Pokazanie i aktualizacja okna
	ShowWindow(uchwytOkna,SW_SHOW);
	UpdateWindow(uchwytOkna);

	return true;
};

WPARAM COkno::Run()
{
	//Petla glowna - obsluga komunikatow
	MSG msg;
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

LRESULT COkno::WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{
	switch (message)
	{
		//przyciski
		case WM_CREATE:
			TworzPrzyciski(hWnd);
			break;
		case WM_COMMAND:
			ObslugaPrzyciskow(wParam);
			break;

		case WM_DESTROY: //Zamykanie okna => konczenie aplikacji
			PostQuitMessage(0);
			break;
		case WM_SIZE: //Zmiana rozmiaru okna
			RECT rect;
			GetClientRect(hWnd, &rect);
			szerokoscObszaruUzytkownika = rect.right - rect.left;
			wysokoscObszaruUzytkownika = rect.bottom - rect.top;			
			Beep(100,10);
			break;
		default: //Automatyczne przetwarzanie komunikatow
			return (DefWindowProc(hWnd, message, wParam, lParam));
	}

	return 0L;
}

void COkno::TworzPrzyciski(HWND uchwytOknaRodzica)
{
	//tworzenie przyciskow - korzystam z pol wc (Window Class)
	hPrzyciskHello = CreateWindow(
		"Button",
		"Hello World!",		
		WS_CHILD | WS_VISIBLE,
		30, 30, 200, 70, //geometria
		uchwytOknaRodzica,
		(HMENU)ID_BUTTON_HELLO,
		wc.hInstance,
		NULL);
	hPrzyciskZamknij = CreateWindow(
		"Button",
		"Zamknij",		
		WS_CHILD | WS_VISIBLE,
		240, 30, 200, 70, //geometria
		uchwytOknaRodzica,
		(HMENU)ID_BUTTON_ZAMKNIJ,
		wc.hInstance,
		NULL);
}

void COkno::ObslugaPrzyciskow(WPARAM wParam)
{
	switch(wParam)
	{
		case ID_BUTTON_HELLO:
			MessageBox(this->uchwytOkna,"Hello World!","Witaj wiecie!",MB_OK);
			break;
		case ID_BUTTON_ZAMKNIJ:
			//DestroyWindow(this->uchwytOkna);
			PostMessage(this->uchwytOkna,WM_CLOSE,0,0);
			break;
	}
}