#include "Okno.h"
#include "resource.h"

#include <commctrl.h>

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
	POINT polozenieOkna={100,100};
	POINT rozmiarOkna={300,300};	
	if (!okno.Init(hInstance,polozenieOkna,rozmiarOkna))
	{
		MessageBox(NULL,"Inicjacja okna nie powioda si","Aplikacja Win32",MB_OK | MB_ICONERROR);
		return EXIT_FAILURE;
	}
	else return okno.Run();
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	return okno.WndProc(hWnd,message,wParam,lParam);
}

bool COkno::Init(HINSTANCE uchwytAplikacji,POINT polozenieOkna,POINT rozmiarOkna)
{
	char nazwaOkna[]="Aplikacja Win32";

	//WNDCLASSEX wc;
	wc.cbSize=sizeof(wc);
	wc.style= CS_HREDRAW | CS_VREDRAW | CS_OWNDC; //styl okna
	wc.lpfnWndProc= (WNDPROC)::WndProc; //procedura okna
	wc.cbClsExtra= 0; //dodatkowe bajty zarezerwowane za klas okna
	wc.cbWndExtra= 0; //dodatkowe bajty zarezerwowane za instancj okna
	wc.hInstance= uchwytAplikacji; //instancja aplikacji
	wc.hIcon= LoadIcon(uchwytAplikacji,MAKEINTRESOURCE(IDI_ICON1)); //uchwyt ikony
	wc.hIconSm= LoadIcon(uchwytAplikacji,MAKEINTRESOURCE(IDI_ICON1)); //uchwyt ikony
	wc.hCursor= LoadCursor(NULL, IDC_ARROW); //uchwyt kursora
	wc.hbrBackground= (HBRUSH)(COLOR_WINDOW+1); //uchwyt pdzla ta
	wc.lpszMenuName= NULL; //nazwa menu
	wc.lpszClassName= nazwaOkna; //nazwa klasy okna	

	//Rejestracja klasy okna
	if(RegisterClassEx(&wc)==0) return false;

	//ustawienia dla okna
	DWORD stylOkna=WS_OVERLAPPEDWINDOW;

	//Tworzenie okna
	uchwytOkna = CreateWindow(
		nazwaOkna, //nazwa klasy okna
		"Kolory", //nazwa okna
		stylOkna,
		polozenieOkna.x,polozenieOkna.y, //pooenie okna (x,y)
		rozmiarOkna.x,rozmiarOkna.y, //rozmiar okna (szeroko, wysoko)
		NULL, //uchwyt okna nadrzdnego (parent)
		NULL, //uchwyt menu
		uchwytAplikacji, //uchwyt instancji aplikacji
		NULL //parametr komunikatu informujacego o utworzeniu okna
	);

	if(uchwytOkna==NULL) return false;

	//Pokazanie i aktualizacja okna
	ShowWindow(uchwytOkna,SW_SHOW);
	UpdateWindow(uchwytOkna);

	return true;
};

WPARAM COkno::Run()
{
	//Petla glowna - obsluga komunikatow
	MSG msg;
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

LRESULT COkno::WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{
	switch (message)
	{
		//przyciski
		case WM_CREATE:
			//TworzPrzyciski(hWnd);
			OnCreate(hWnd,message,wParam,lParam);
			break;

		case WM_COMMAND:
			//ObslugaPrzyciskow(wParam);			
			break;

		//obsluga suwakow
		case WM_CTLCOLORSTATIC:
		{
			DWORD dwPos1 = SendMessage(hTrackBar1, TBM_GETPOS, 0, 0);
			DWORD dwPos2 = SendMessage(hTrackBar2, TBM_GETPOS, 0, 0);
			DWORD dwPos3 = SendMessage(hTrackBar3, TBM_GETPOS, 0, 0);
			HWND hCtl =(HWND)lParam;
			HBRUSH brush=CreateSolidBrush(RGB((int)dwPos1,(int)dwPos2,(int)dwPos3));
			if(hCtl == hPanel) return (LRESULT) brush;
			else return (LRESULT)GetStockObject(WHITE_BRUSH);
		}
		case  WM_HSCROLL:
			RedrawWindow(hPanel,NULL,NULL,RDW_INVALIDATE);
			break;

		case WM_SIZE:
			OnSize(hWnd,message,wParam,lParam);			
			break;

		case WM_DESTROY: //Zamykanie okna => konczenie aplikacji
			PostQuitMessage(0);
			break;
		default: //Automatyczne przetwarzanie komunikatow
			return (DefWindowProc(hWnd, message, wParam, lParam));
	}

	return 0L;
}

void COkno::TworzPrzyciski(HWND uchwytOknaRodzica)
{
	//tworzenie przyciskow - korzystam z pol wc (Window Class)
	hPrzyciskHello = CreateWindow(
		"Button",
		"Hello World!",		
		WS_CHILD | WS_VISIBLE,
		30, 30, 200, 70, //geometria
		uchwytOknaRodzica,
		(HMENU)ID_BUTTON_HELLO,
		wc.hInstance,
		NULL);
	hPrzyciskZamknij = CreateWindow(
		"Button",
		"Zamknij",		
		WS_CHILD | WS_VISIBLE,
		240, 30, 200, 70, //geometria
		uchwytOknaRodzica,
		(HMENU)ID_BUTTON_ZAMKNIJ,
		wc.hInstance,
		NULL);
}

void COkno::ObslugaPrzyciskow(WPARAM wParam)
{
	switch(wParam)
	{
		case ID_BUTTON_HELLO:
			MessageBox(this->uchwytOkna,"Hello World!","Witaj wiecie!",MB_OK);
			break;
		case ID_BUTTON_ZAMKNIJ:
			//DestroyWindow(this->uchwytOkna);
			PostMessage(this->uchwytOkna,WM_CLOSE,0,0);
			break;
	}
}

//#include <commctrl.h>
//W ustawieniach Linker,Input,Additional dependencies: comctl32.lib.

HWND COkno::TworzSuwak(
    HWND uchwytOknaRodzica,
    UINT min, UINT max,
    UINT selMin, UINT selMax,
	RECT rect,
    HMENU id)
{
	INITCOMMONCONTROLSEX icc;
	icc.dwSize=sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC=ICC_BAR_CLASSES; //MSDN: Load toolbar, status bar, trackbar, and tooltip control classes.
    InitCommonControlsEx(&icc);
    HWND hwndTrack = CreateWindow(
        TRACKBAR_CLASS,
        "Kontrolka Trackbar",
        WS_CHILD | WS_VISIBLE | TBS_ENABLESELRANGE | TBS_AUTOTICKS,
        rect.left, rect.top,
        rect.right-rect.left, rect.bottom-rect.top,
        uchwytOknaRodzica,
        id,
        wc.hInstance,
        NULL
        );

	//ustawiamy min i max trackabara
    SendMessage(hwndTrack, TBM_SETRANGE,
        (WPARAM) TRUE,
        (LPARAM) MAKELONG(min, max));

    SendMessage(hwndTrack, TBM_SETPAGESIZE,
        0, (LPARAM) 4);

    SendMessage(hwndTrack, TBM_SETTICFREQ,
        15, (LPARAM) 1);

    SendMessage(hwndTrack, TBM_SETSEL,
        (WPARAM) FALSE,
        (LPARAM) MAKELONG(selMin, selMax));

    SendMessage(hwndTrack, TBM_SETPOS,
        (WPARAM) TRUE,
        (LPARAM) selMin);

    SetFocus(hwndTrack);
    
	return hwndTrack;
}

LRESULT COkno::OnCreate(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{
	int margines = 10;
	int szerokosc = 270;
	int wysokoscSuwakow = 30;
	
	//tworzymy panel
	hPanel = CreateWindow(
		"STATIC",
		"", //pusta etykieta, zeby nie bylo napisu
		WS_CHILD | WS_VISIBLE,
		margines, margines,
		szerokosc, 120,
		hWnd,
		(HMENU)ID_PANEL,
		wc.hInstance, //GetModuleHandle(NULL),
		NULL);

	//tworzymy suwaki
	RECT rect;
	//rect.left=margines; rect.right=rectClientArea.right-margines;
	rect.left=10; rect.right=rect.left+szerokosc;
	rect.top=150; rect.bottom=rect.top+wysokoscSuwakow;
	hTrackBar1=TworzSuwak(hWnd, 0,255,0,0, rect, (HMENU)ID_TRACKBAR1);
	rect.top+=40; rect.bottom=rect.top+wysokoscSuwakow;
	hTrackBar2=TworzSuwak(hWnd, 0,255,0,0, rect, (HMENU)ID_TRACKBAR2);
	rect.top+=40; rect.bottom=rect.top+wysokoscSuwakow;
	hTrackBar3=TworzSuwak(hWnd, 0,255,0,0, rect, (HMENU)ID_TRACKBAR3);

	SetFocus(hTrackBar1);

	return 0;
}

LRESULT COkno::OnSize(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{
	RECT rectClientArea;
	GetClientRect(this->uchwytOkna,&rectClientArea);
	int szerObszaruKlienta=rectClientArea.right-rectClientArea.left;
	int wysObszaruKlienta=rectClientArea.bottom-rectClientArea.top;

	int margines = 10;
	int szerokosc = szerObszaruKlienta-2*margines;
	int wysokoscSuwakow = 30;

	SetWindowPos(hPanel,NULL,margines,margines,szerokosc,wysObszaruKlienta-5*margines-3*wysokoscSuwakow,SWP_NOACTIVATE);
	SetWindowPos(hTrackBar1,NULL,margines,wysObszaruKlienta-3*margines-3*wysokoscSuwakow,szerokosc,wysokoscSuwakow,SWP_NOACTIVATE);
	SetWindowPos(hTrackBar2,NULL,margines,wysObszaruKlienta-2*margines-2*wysokoscSuwakow,szerokosc,wysokoscSuwakow,SWP_NOACTIVATE);
	SetWindowPos(hTrackBar3,NULL,margines,wysObszaruKlienta-margines-1*wysokoscSuwakow,szerokosc,wysokoscSuwakow,SWP_NOACTIVATE);	
	
	return 0;
}