
// InternetDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Internet.h"
#include "InternetDlg.h"
#include "afxdialogex.h"

//dodane
#include <wininet.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CInternetDlg dialog




CInternetDlg::CInternetDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CInternetDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CInternetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, edit1);
	DDX_Control(pDX, IDC_EDIT2, edit2);
	DDX_Control(pDX, IDC_EDIT3, edit3);
	DDX_Control(pDX, IDC_EDIT4, edit4);
	DDX_Control(pDX, IDC_PICTURE, picture);
	DDX_Control(pDX, IDC_EDIT5, edit5);
	DDX_Control(pDX, IDC_EDIT6, edit6);
}

BEGIN_MESSAGE_MAP(CInternetDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON2, &CInternetDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CInternetDlg::OnBnClickedButton3)
	ON_WM_CLOSE()
//	ON_BN_CLICKED(IDC_BUTTON1, &CInternetDlg::OnBnClickedButton1)
ON_BN_CLICKED(IDC_BUTTON1, &CInternetDlg::OnBnClickedButton1)
END_MESSAGE_MAP()


// CInternetDlg message handlers

BOOL CInternetDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	edit5.SetWindowTextW(L"Nazwa lub IP:");
	edit6.SetWindowTextW(L"Wynik");

	WSADATA wsaData;
	WSAStartup(MAKEWORD(1,0),&wsaData);
	OnBnClickedButton3();

    unsigned long typPolaczen=0;
    BOOL wynik=InternetGetConnectedState(&typPolaczen,0);
    bool polaczenieLAN=(typPolaczen & INTERNET_CONNECTION_LAN)>0;
    bool polaczenieModem=(typPolaczen & INTERNET_CONNECTION_MODEM)>0;
    bool polaczenieTrybOffline=(typPolaczen & INTERNET_CONNECTION_OFFLINE)>0;
    bool polaczenieProxy=(typPolaczen & INTERNET_CONNECTION_PROXY)>0;
    bool polaczenieRAS=(typPolaczen & INTERNET_RAS_INSTALLED)>0;

	char bufor[3];
	_itoa_s(typPolaczen,bufor,10);	

	CString czyPolaczenieAktywne = L"Poczenie aktywne: ";
	czyPolaczenieAktywne+=(wynik?"tak":"nie");
	edit1.SetWindowTextW(czyPolaczenieAktywne);
    CString polaczenia=L"Poczenia ("+(CString)bufor+"): ";
    if(polaczenieLAN) polaczenia+=L"LAN; ";
    if(polaczenieModem) polaczenia+=L"modem; ";
    if(polaczenieTrybOffline) polaczenia+=L"offline; ";
    if(polaczenieProxy) polaczenia+=L"proxy; ";
    if(polaczenieRAS) polaczenia+=L"RAS; ";
    edit2.SetWindowTextW(polaczenia);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CInternetDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CInternetDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

//Po umieszczeniu na oknie Picture Control trzeba zmienic jego ID na IDC_PICTURE, a Type na Bitmap
void CInternetDlg::OnBnClickedButton1()
{
    wchar_t temp[MAX_PATH];
    GetTempPath(MAX_PATH,temp);
	CString nazwaPliku= (CString)temp+L"\\torun1.bmp";
    //ShowMessage(nazwaPliku);
    if(URLDownloadToFile(
        NULL,
        L"http://www.fizyka.umk.pl/~jacek/img/torun.bmp",
        nazwaPliku.GetString(),
        0,
        NULL)==S_OK)
    {
		HBITMAP hBitmap = (HBITMAP)LoadImage(NULL, nazwaPliku, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE | LR_CREATEDIBSECTION | LR_DEFAULTSIZE); 
		picture.SetBitmap(hBitmap);
        MessageBox(L"Plik pobrany",L"Internet",MB_OK);
    }
    else MessageBox(L"Bd podczas pobierania pliku",L"Internet",MB_OK);
}

CString AdresIP(CString& nazwaKomputera,bool inicjacja=true,bool czyszczenie=true)
{
	//adujemy bibliotek Winsock
	if (inicjacja)
	{
		WORD wVersionRequested=MAKEWORD(1,0);
		WSADATA wsaData;
		WSAStartup(wVersionRequested,&wsaData);
	}

	//Sprawdzamy informacje o komputerze
	char bufor[MAX_COMPUTERNAME_LENGTH];
	WideCharToMultiByte(CP_ACP, 0, nazwaKomputera, -1, bufor, MAX_COMPUTERNAME_LENGTH, NULL, NULL);
	hostent* pInfoKomputer=gethostbyname(bufor);
	nazwaKomputera=pInfoKomputer->h_name;
	//Konwertujemy adres IP protokou IPv4 na acuch z kropkami
	in_addr* pAdres=(in_addr*)(*(pInfoKomputer->h_addr_list));
	CString wynik=(CString)inet_ntoa(*pAdres);

	//Zwalniamy Winsock
	if (czyszczenie)
	{
		WSACleanup();
	}

	return wynik;
}

CString NazwaDNS(CString adresIP,bool inicjacja=true,bool czyszczenie=true)
{
	//adujemy bibliotek Winsock
	if (inicjacja)
	{
		WORD wVersionRequested=MAKEWORD(1,0);
		WSADATA wsaData;
		WSAStartup(wVersionRequested,&wsaData);
	}

	//Sprawdzamy informacje o komputerze
	char bufor[256]="";
	WideCharToMultiByte(CP_ACP, 0, adresIP, -1, bufor, 256, NULL, NULL);
	unsigned long dwAdresIP=inet_addr(bufor);
	hostent* pInfoKomputer=gethostbyaddr((char*)&dwAdresIP,sizeof(unsigned long),AF_INET);
	CString wynik=L"";
	if (pInfoKomputer!=NULL) wynik=(CString)(pInfoKomputer->h_name);
	else MessageBox(NULL,L"Pobranie nazwy komputera nie powiodo si",L"Internet",MB_OK);

	//Zwalniamy Winsock
	if (czyszczenie)
	{
		WSACleanup();
	}

	return wynik;
}

void CInternetDlg::OnBnClickedButton2()
{
	wchar_t edit3Text[256]=L"";
	edit3.GetWindowTextW(edit3Text,256);
    if (edit3Text==L"") return;
	wchar_t pierwszyZnak=edit3Text[0];
	if (pierwszyZnak>='0' && pierwszyZnak<='9') //adres IP czy nazwa DNS
	{
		edit4.SetWindowTextW(NazwaDNS(edit3Text,false,false));
        edit6.SetWindowTextW(L"Nazwa DNS:");
	}
	else
	{
		CString nazwaKomputera=edit3Text; //aby przekazac TCaption do AdresIP
		edit4.SetWindowTextW(AdresIP(nazwaKomputera,false,false));
		edit3.SetWindowTextW(nazwaKomputera);
        edit6.SetWindowTextW(L"Adres IP:");
	}
}


void CInternetDlg::OnBnClickedButton3()
{
    //Pobieramy nazw lokalnego komputera
	wchar_t nazwaKomputera[MAX_COMPUTERNAME_LENGTH];
	unsigned long dlugoscNazwyKomputera;
	GetComputerName(nazwaKomputera,&dlugoscNazwyKomputera);
	edit3.SetWindowText(nazwaKomputera);

	//Pobieramy IP lokalnego komputera
	OnBnClickedButton2();
}


void CInternetDlg::OnClose()
{
	WSACleanup();

	CDialogEx::OnClose();
}

