
// FormatMessageDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FormatMessage.h"
#include "FormatMessageDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CFormatMessageDlg dialog




CFormatMessageDlg::CFormatMessageDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CFormatMessageDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFormatMessageDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, Edit1);
	DDX_Control(pDX, IDC_SPIN1, Spin1);
	DDX_Control(pDX, IDC_EDIT2, Edit2);
}

BEGIN_MESSAGE_MAP(CFormatMessageDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_CHANGE(IDC_EDIT1, &CFormatMessageDlg::OnEnChangeEdit1)
	ON_BN_CLICKED(IDC_BUTTON1, &CFormatMessageDlg::OnBnClickedButton1)
END_MESSAGE_MAP()


// CFormatMessageDlg message handlers

BOOL CFormatMessageDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here	
	Edit2.SetWindowTextW(L"---");
	Edit1.SetWindowTextW(L"0");	
	Spin1.SetRange32(0,65536);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFormatMessageDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFormatMessageDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


CString OpisBledu(DWORD kodBledu, bool wyswietlKomunikat = false)
{
    LPVOID lpMsgBuf;

    DWORD iloscBajtow=FormatMessage(
        FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
        NULL,
        kodBledu,//GetLastError(),
        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
        (LPTSTR) &lpMsgBuf,
        0,
        NULL
    );

    if(iloscBajtow == 0) throw L"*** Nie udao si znalec opisu bdu!";

    // Display the string.
    if(wyswietlKomunikat)
        MessageBox( NULL, (wchar_t *)lpMsgBuf, L"Opis bdu", MB_OK | MB_ICONINFORMATION );

    CString opisBledu=(wchar_t *)lpMsgBuf;
    opisBledu=opisBledu.TrimRight();

    // Free the buffer.
    LocalFree(lpMsgBuf);

    //Beep(100,100);

    return opisBledu;
}

//UWAGA! Zwiazanie Spin Control z Edit Control poprzez wlasnosci Auto Buddy i Set Buddy Integer, Aligment = Right

void CFormatMessageDlg::OnEnChangeEdit1()
{	
	if(Edit1.m_hWnd==NULL) return; //zakoncz jezeli kontrolki nie zainicjowane

	try
    {
		wchar_t bufor[256];
		Edit1.GetWindowTextW(bufor,256);
		DWORD kodBledu = _wtoi(bufor);		
		Edit2.SetWindowTextW(OpisBledu(kodBledu));        
    }
    catch(wchar_t* exc)
    {
        Edit2.SetWindowTextW(exc);
    }
}


void CFormatMessageDlg::OnBnClickedButton1()
{
	this->OnOK();
}
