#include "Zrzut.h"
#include <fstream>
#include <time.h>

void screen( HWND okno, const char * plik1 )
{
    HDC _dc = GetWindowDC( okno );
    RECT re;
    GetWindowRect( okno, & re );
    int w = re.right, h = re.bottom;
    HDC dc = CreateCompatibleDC( 0 );
    HBITMAP bm = CreateCompatibleBitmap( _dc, w, h );
    SelectObject( dc, bm );
    StretchBlt( dc, 0, 0, w, h, _dc, 0, 0, w, h, SRCCOPY );
	LPCWSTR plik = (LPCWSTR)(plik1);
    void * f = CreateFile( plik, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 0, 0 );
    void * buf = new char[ w * h * 3 ];
    GetObject( bm, 84, buf );
    HDC ddd = GetDC( 0 );
    HDC dc2 = CreateCompatibleDC( ddd );
    tagBITMAPINFO bi;
    bi.bmiHeader.biSize = sizeof( bi.bmiHeader );
    bi.bmiHeader.biWidth = w;
    bi.bmiHeader.biHeight = h;
    bi.bmiHeader.biPlanes = 1;
    bi.bmiHeader.biBitCount = 24;
    bi.bmiHeader.biCompression = 0;
    bi.bmiHeader.biSizeImage = w * h * 3;
    
    CreateDIBSection( dc, & bi, DIB_RGB_COLORS, & buf, 0, 0 );
    GetDIBits( dc, bm, 0, h, buf, & bi, DIB_RGB_COLORS );

    BITMAPFILEHEADER bif;
    bif.bfType = MAKEWORD( 'B', 'M' );
    bif.bfSize = w * h * 3 + 54;
    bif.bfOffBits = 54;
    bi.bmiHeader.biClrImportant = 0;
    bi.bmiHeader.biClrUsed = 0;
    bif.bfReserved1 = 0;
    bif.bfReserved2 = 0;
    
    BITMAPINFOHEADER bii;
    bii.biSize = 40;
    bii.biWidth = w;
    bii.biHeight = h;
    bii.biPlanes = 1;
    bii.biBitCount = 24;
    bii.biCompression = 0;
    bii.biSizeImage = w * h * 3;
    
    
    DWORD r;
    WriteFile( f, & bif, sizeof( bif ), & r, NULL );
    WriteFile( f, & bii, sizeof( bii ), & r, NULL );
    WriteFile( f, buf, w * h * 3, & r, NULL );
    CloseHandle( f );

}

void CaptureScreen(HWND window, const char* filename)
{
 RECT windowRect;
 GetWindowRect(window, &windowRect);

 int bitmap_dx = windowRect.right - windowRect.left;
 int bitmap_dy = windowRect.bottom - windowRect.top;

 std::ofstream file;
 if(!file) return;

 BITMAPFILEHEADER fileHeader;
 BITMAPINFOHEADER infoHeader;

 fileHeader.bfType      = 0x4d42;
 fileHeader.bfSize      = 0;
 fileHeader.bfReserved1 = 0;
 fileHeader.bfReserved2 = 0;
 fileHeader.bfOffBits   = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

 infoHeader.biSize          = sizeof(infoHeader);
 infoHeader.biWidth         = bitmap_dx;
 infoHeader.biHeight        = bitmap_dy;
 infoHeader.biPlanes        = 1;
 infoHeader.biBitCount      = 24;
 infoHeader.biCompression   = BI_RGB;
 infoHeader.biSizeImage     = 0;
 infoHeader.biXPelsPerMeter = 0;
 infoHeader.biYPelsPerMeter = 0;
 infoHeader.biClrUsed       = 0;
 infoHeader.biClrImportant  = 0;

 file.write((char*)&fileHeader, sizeof(fileHeader));
 file.write((char*)&infoHeader, sizeof(infoHeader));

 BITMAPINFO info;
 info.bmiHeader = infoHeader; 
 HDC winDC = GetWindowDC(window);
 HDC memDC = CreateCompatibleDC(winDC);
 BYTE* memory = 0;
 HBITMAP bitmap = CreateDIBSection(winDC, &info, DIB_RGB_COLORS, (void**)&memory, 0, 0);
 SelectObject(memDC, bitmap);
 BitBlt(memDC, 0, 0, bitmap_dx, bitmap_dy, winDC, 0, 0, SRCCOPY);
 DeleteDC(memDC);
 ReleaseDC(window, winDC);
 int bytes = (((24*bitmap_dx + 31) & (~31))/8)*bitmap_dy;
 file.write((char*)memory, bytes);
 DeleteObject(bitmap);
}

void CaptureScreen()
{
    int szerOkna = GetSystemMetrics(SM_CXSCREEN);
    int wysOkna = GetSystemMetrics(SM_CYSCREEN);
    HWND hwndPulpit = GetDesktopWindow();
    HDC hdcPulpit = GetDC(hwndPulpit);
    HDC hdcScreen = CreateCompatibleDC(hdcPulpit);
    HBITMAP hCaptureBitmap =CreateCompatibleBitmap(hdcPulpit, 
                            szerOkna, wysOkna);
    SelectObject(hdcScreen,hCaptureBitmap); 
    BitBlt(hdcScreen,0,0,szerOkna,wysOkna,
           hdcPulpit,0,0,SRCCOPY|CAPTUREBLT); 
	WriteBMP(hCaptureBitmap, hdcPulpit, L"screen.bmp");

    ReleaseDC(hwndPulpit,hdcPulpit);
    DeleteDC(hdcScreen);
    DeleteObject(hCaptureBitmap);
}
void WriteBMP(HBITMAP bitmap, HDC hDC, LPTSTR filename)
{
	BITMAP bmp; 
	PBITMAPINFO pbmi; 
	WORD cClrBits; 
	HANDLE hf;  
	BITMAPFILEHEADER hdr;  
	PBITMAPINFOHEADER pbih;
	LPBYTE lpBits;
	DWORD dwTotal;  
	DWORD cb;  
	BYTE *hp;  
	DWORD dwTmp; 

	if (!GetObject( bitmap, sizeof(BITMAP), (LPSTR)&bmp))
	{
		return;
	}

	
	cClrBits = (WORD)(bmp.bmPlanes * bmp.bmBitsPixel); 
	if (cClrBits == 1) 
	cClrBits = 1; 
	else if (cClrBits <= 4) 
	cClrBits = 4; 
	else if (cClrBits <= 8) 
	cClrBits = 8; 
	else if (cClrBits <= 16) 
	cClrBits = 16; 
	else if (cClrBits <= 24) 
	cClrBits = 24; 
	else cClrBits = 32; 
	if (cClrBits != 24) 
	pbmi = (PBITMAPINFO) LocalAlloc(LPTR, 
	sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * (1<< cClrBits)); 
	else 
	pbmi = (PBITMAPINFO) LocalAlloc(LPTR, sizeof(BITMAPINFOHEADER)); 

	pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER); 
	pbmi->bmiHeader.biWidth = bmp.bmWidth; 
	pbmi->bmiHeader.biHeight = bmp.bmHeight; 
	pbmi->bmiHeader.biPlanes = bmp.bmPlanes; 
	pbmi->bmiHeader.biBitCount = bmp.bmBitsPixel; 
	if (cClrBits < 24) 
	pbmi->bmiHeader.biClrUsed = (1<<cClrBits); 

	pbmi->bmiHeader.biCompression = BI_RGB; 

	pbmi->bmiHeader.biSizeImage = (pbmi->bmiHeader.biWidth + 7) /8 * pbmi->bmiHeader.biHeight * cClrBits; 
	pbmi->bmiHeader.biClrImportant = 0; 

	pbih = (PBITMAPINFOHEADER) pbmi; 
	lpBits = (LPBYTE) GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);

	if (!lpBits) 
	{
		return;
	}

	if (!GetDIBits(hDC, HBITMAP(bitmap), 0, (WORD) pbih->biHeight, lpBits, pbmi, 
	DIB_RGB_COLORS)) 
	{
		return;
	}


	hf = CreateFile(filename, GENERIC_READ | GENERIC_WRITE, (DWORD) 0, 
	NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 
	(HANDLE) NULL); 
	if (hf == INVALID_HANDLE_VALUE)
	{
		return;
	}
	hdr.bfType = 0x4d42; 
	hdr.bfSize = (DWORD) (sizeof(BITMAPFILEHEADER) + 
	pbih->biSize + pbih->biClrUsed 
	* sizeof(RGBQUAD) + pbih->biSizeImage); 
	hdr.bfReserved1 = 0; 
	hdr.bfReserved2 = 0; 

	hdr.bfOffBits = (DWORD) sizeof(BITMAPFILEHEADER) + 
	pbih->biSize + pbih->biClrUsed 
	* sizeof (RGBQUAD); 
	if (!WriteFile(hf, (LPVOID) &hdr, sizeof(BITMAPFILEHEADER), 
	(LPDWORD) &dwTmp, NULL)) 
	{
		return;
	}

	
	if (!WriteFile(hf, (LPVOID) pbih, sizeof(BITMAPINFOHEADER) 
	+ pbih->biClrUsed * sizeof (RGBQUAD), 
	(LPDWORD) &dwTmp, ( NULL)))
	{
		return;
	}


	dwTotal = cb = pbih->biSizeImage; 
	hp = lpBits; 
	if (!WriteFile(hf, (LPSTR) hp, (int) cb, (LPDWORD) &dwTmp,NULL))
	{
		return;
	}

	if (!CloseHandle(hf))
	{
		return;
	}

	GlobalFree((HGLOBAL)lpBits);
}