#include "KlasaBazowa.h"
#include <assert.h>
#include <strsafe.h>

//Tylko jedna instancja moe by uruchomiona na raz!
KlasaBazowa *KlasaBazowa::s_service = NULL;
BOOL KlasaBazowa::Run(KlasaBazowa &service) //ustalenie punktu wejcia
{
    s_service = &service;

    SERVICE_TABLE_ENTRY serviceTable[] = 
    {
        { service.m_name, ServiceMain },
        { NULL, NULL }
    };
    return StartServiceCtrlDispatcher(serviceTable); //Podczenie pod SCMa
}


void WINAPI KlasaBazowa::ServiceMain(DWORD dwArgc, PWSTR *pszArgv)
{
    assert(s_service != NULL);
	//Warto zarejestrowa ten uchwyt - inaczej jest niewesoo
    s_service->m_statusHandle = RegisterServiceCtrlHandler(
        s_service->m_name, ServiceCtrlHandler);
    if (s_service->m_statusHandle == NULL)
    {
        throw GetLastError();
    }

    s_service->Start(dwArgc, pszArgv); //uruchomienie usugi
}

//Kontrolowanie usugi z poziomu SCM'a - tego brakowao wczeniej
void WINAPI KlasaBazowa::ServiceCtrlHandler(DWORD dwCtrl)
{
    switch (dwCtrl)
    {
    case SERVICE_CONTROL_STOP: s_service->Stop(); break;
    case SERVICE_CONTROL_PAUSE: s_service->Pause(); break;
    case SERVICE_CONTROL_CONTINUE: s_service->Continue(); break;
    case SERVICE_CONTROL_SHUTDOWN: s_service->Shutdown(); break;
    case SERVICE_CONTROL_INTERROGATE: break;
    default: break;
    }
}

KlasaBazowa::KlasaBazowa(PWSTR pszServiceName, BOOL fCanStop, BOOL fCanShutdown, BOOL fCanPauseContinue)
{
    m_name = (pszServiceName == NULL) ? L"" : pszServiceName; //nazwa usugi musi by rna od znaku pustego
    m_statusHandle = NULL;
    m_status.dwServiceType = SERVICE_WIN32_OWN_PROCESS; //Usuga dziaa we wasnym procesie - tak jest bezpieczniej i trudniej popsu 
    m_status.dwCurrentState = SERVICE_START_PENDING;
    DWORD dwControlsAccepted = 0;
    if (fCanStop) 
        dwControlsAccepted |= SERVICE_ACCEPT_STOP;
    if (fCanShutdown) 
        dwControlsAccepted |= SERVICE_ACCEPT_SHUTDOWN;
    if (fCanPauseContinue) 
        dwControlsAccepted |= SERVICE_ACCEPT_PAUSE_CONTINUE;
    m_status.dwControlsAccepted = dwControlsAccepted;
    m_status.dwWin32ExitCode = NO_ERROR;
    m_status.dwServiceSpecificExitCode = 0;
    m_status.dwCheckPoint = 0;
    m_status.dwWaitHint = 0;
}

//Bez tego destruktora bywaj problemy z wyczeniem usugi
KlasaBazowa::~KlasaBazowa(void)
{
}

void KlasaBazowa::Start(DWORD dwArgc, PWSTR *pszArgv)
{
    try //rozmowa z SCM
    {
        SetServiceStatus(SERVICE_START_PENDING);
        OnStart(dwArgc, pszArgv);
        SetServiceStatus(SERVICE_RUNNING);
    }
    catch (...)
    {
		wprintf(L"Nie udao si powiadomi SCM'a o usudze.\n");
        SetServiceStatus(SERVICE_STOPPED);
    }
}

void KlasaBazowa::OnStart(DWORD dwArgc, PWSTR *pszArgv)
{
}

void KlasaBazowa::Stop()
{
    DWORD dwOriginalState = m_status.dwCurrentState;
    try
    {
        SetServiceStatus(SERVICE_STOP_PENDING);
        OnStop();
        SetServiceStatus(SERVICE_STOPPED);
    }
    catch (DWORD dwError)
    {
		wprintf(L"Usuga zostaa zatrzymana");
        SetServiceStatus(dwOriginalState);
    }
    catch (...)
    {
       wprintf(L"Usuga nie moe zosta zatrzymana");
        SetServiceStatus(dwOriginalState);
    }
}

void KlasaBazowa::OnStop()
{
}

void KlasaBazowa::Pause()
{
    try
    {
        SetServiceStatus(SERVICE_PAUSE_PENDING);
        OnPause();
        SetServiceStatus(SERVICE_PAUSED);
    }
    catch (DWORD dwError)
    {
        wprintf(L"Usuga zostaa zatrzymana\n");
        SetServiceStatus(SERVICE_RUNNING);
    }
    catch (...)
    {
        wprintf(L"Usuga nie zostaa zatrzymana\n");
        SetServiceStatus(SERVICE_RUNNING);
    }
}

void KlasaBazowa::OnPause()
{
}

void KlasaBazowa::Continue()
{
    try
    {
        SetServiceStatus(SERVICE_CONTINUE_PENDING);
        OnContinue();
        SetServiceStatus(SERVICE_RUNNING);
    }
    catch (DWORD dwError)
    {
        wprintf(L"Usuga wci zatrzymana.\n");
        SetServiceStatus(SERVICE_PAUSED);
    }
    catch (...)
    {
        wprintf(L"Usuga nie moe zosta przywrcona.\n");
        SetServiceStatus(SERVICE_PAUSED);
    }
}

void KlasaBazowa::OnContinue()
{
}

void KlasaBazowa::Shutdown()
{
    try
    {
        OnShutdown();
        SetServiceStatus(SERVICE_STOPPED);
    }
    catch (DWORD dwError)
    {
        wprintf(L"Usuga zostaa wyczona.\n");
    }
    catch (...)
    {
        wprintf(L"Usuga nie moe zosta zatrzymana.\n");
    }
}

void KlasaBazowa::OnShutdown()
{
}

void KlasaBazowa::SetServiceStatus(DWORD dwCurrentState, DWORD dwWin32ExitCode, DWORD dwWaitHint)
{
    static DWORD dwCheckPoint = 1;
    m_status.dwCurrentState = dwCurrentState;
    m_status.dwWin32ExitCode = dwWin32ExitCode;
    m_status.dwWaitHint = dwWaitHint;
    m_status.dwCheckPoint = ((dwCurrentState == SERVICE_RUNNING) | (dwCurrentState == SERVICE_STOPPED)) ? 0 : dwCheckPoint++;
    ::SetServiceStatus(m_statusHandle, &m_status);
}