#include <stdio.h>
#include <windows.h>
#include "Instalacja.h"

void InstallService(PWSTR pszServiceName, PWSTR pszDisplayName, DWORD dwStartType, PWSTR pszDependencies, PWSTR pszAccount, PWSTR pszPassword)
{
    wchar_t szPath[MAX_PATH];
    SC_HANDLE SCM = NULL;
    SC_HANDLE usluga = NULL;

    if (GetModuleFileName(NULL, szPath, ARRAYSIZE(szPath)) == 0)
    {
        wprintf(L"Nie mona pobra nazwy moduu.\n");
		return;
    }

    SCM = OpenSCManager(NULL, NULL, SC_MANAGER_CONNECT | SC_MANAGER_CREATE_SERVICE);
    if (SCM == NULL)
    {
        wprintf(L"Problem z otwarciem SCM'a.\n");
		return;
    }

    usluga = CreateService(SCM, pszServiceName, pszDisplayName, SERVICE_QUERY_STATUS, SERVICE_WIN32_OWN_PROCESS, dwStartType, SERVICE_ERROR_NORMAL,
						   szPath, NULL, NULL, pszDependencies, pszAccount, pszPassword);
    if (usluga == NULL)
    {
        wprintf(L"Nie mona utworzy usugi.\n");
		return;
    }

	wprintf(L"Usuga zostaa poprawnie zainstalowana.\n");
}


void UninstallService(PWSTR pszServiceName)
{
    SC_HANDLE SCM = NULL;
    SC_HANDLE usluga = NULL;
    SERVICE_STATUS status = {};

    SCM = OpenSCManager(NULL, NULL, SC_MANAGER_CONNECT);
    if (SCM == NULL)
    {
        wprintf(L"Problem z otwarciem SCM'a.\n");
		return;
    }

    usluga = OpenService(SCM, pszServiceName, SERVICE_STOP | SERVICE_QUERY_STATUS | DELETE);
    if (usluga == NULL)
    {
        wprintf(L"Problem z otwarciem usugi.\n");
        return;
    }

    if (ControlService(usluga, SERVICE_CONTROL_STOP, &status))
    {
        wprintf(L"Zatrzymywanie %s.", pszServiceName);
        Sleep(1000);

        while (QueryServiceStatus(usluga, &status))
        {
            if (status.dwCurrentState == SERVICE_STOP_PENDING)
            {
                wprintf(L".");
                Sleep(1000);
            }
            else break;
        }

        if (status.dwCurrentState == SERVICE_STOPPED)
        {
            wprintf(L"\n%s jest zatrzymana.\n", pszServiceName);
        }
        else
        {
            wprintf(L"\n%s nie moe zosta zatrzymana.\n", pszServiceName);
        }
    }

    if (!DeleteService(usluga))
    {
        wprintf(L"Nie mona zatrzyma usugi.\n");
        return;
    }

    wprintf(L"Usuga %s zostaa usunita.\n", pszServiceName);
}