#include <stdio.h>
#include <windows.h>
#include "Instalacja.h"
#include "KlasaBazowa.h"
#include "Usluga.h"

#define SERVICE_NAME             L"SylwiaSSS" //Nazwa usugi
#define SERVICE_DISPLAY_NAME     L"Sylwia ScreenShoot Service" // Wywietlana nazwa
#define SERVICE_START_TYPE       SERVICE_DEMAND_START //uruchamiana "z rki"
#define SERVICE_DEPENDENCIES     L"" // niezalena od innych usug
#define SERVICE_ACCOUNT          L"NT AUTHORITY\\LocalService" //konto, na ktrym mona j wykona
#define SERVICE_PASSWORD         NULL //haso do usugi

int wmain(int argc, wchar_t *argv[])
{
    if ((argc > 1) && ((*argv[1] == L'-')))
    {
        if (_wcsicmp(L"install", argv[1] + 1) == 0)
        {
            InstallService(SERVICE_NAME, SERVICE_DISPLAY_NAME, SERVICE_START_TYPE, SERVICE_DEPENDENCIES, SERVICE_ACCOUNT, SERVICE_PASSWORD);
        }
        else if (_wcsicmp(L"remove", argv[1] + 1) == 0)
        {
            UninstallService(SERVICE_NAME);
        }
		else
		{
			wprintf(L"Niepoprawny parametr!\n");
		}
    }
    else
    {
        Usluga service(SERVICE_NAME);
        if (!KlasaBazowa::Run(service))
        {
            wprintf(L"Upss... Nie mona uruchomi usugi!\n");
        }
    }
    return 0;
}