#define WIN32_LEAN_AND_MEAN

#ifndef MYSZ_H
#define MYSZ_H

#include <Windows.h>
#include <CommCtrl.h>
#include <string>

#define WS_POPUPKIND (0x80000000L | 0x00C00000L | 0x00080000L | 0x00020000L)

// Group box
HWND hGroupPosition, hGroupModifiers, hGroupOthers;

// Static labels
HWND hLabelX, hLabelY, hLabelChange;

// Edit boxes
HWND hEditX, hEditY;

// Buttons
HWND hButtonSetCursor, hButtonGetCursor, hButtonWindow, hButtonRestore;

// Checkboxes
HWND hCheckClip, hCheckHide, hCheckPos;

// Combobox
HWND hComboModifiers;

enum { BT_SETCURSOR = 1, BT_GETCURSOR, BT_WINDOW, BT_RESTORE };
enum { CB_CLIP = 5, CB_HIDE, CB_POS };
enum { COMBO_MODIFIERS = 8 };

char* temp = new char[1024];

void ChangeControlFont(HWND hWndControl) 
{ 
	HFONT hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage(hWndControl, WM_SETFONT, (WPARAM)hFont, 1);  
}

void ChangeClassCursors(LONG cursorStyle)
{
	SetClassLong(hGroupModifiers, GCL_HCURSOR, cursorStyle);
	SetClassLong(hGroupOthers, GCL_HCURSOR, cursorStyle);
	SetClassLong(hGroupPosition, GCL_HCURSOR, cursorStyle);
	SetClassLong(hEditX, GCL_HCURSOR, cursorStyle);
	SetClassLong(hEditY, GCL_HCURSOR, cursorStyle);
	SetClassLong(hComboModifiers, GCL_HCURSOR, cursorStyle);
}

void MouseChange()
{
	int listIndex = SendMessage(hComboModifiers, CB_GETCURSEL, NULL, NULL);
	switch(listIndex)
	{
	case 0:
		ChangeClassCursors((LONG)IDC_APPSTARTING);
		SetCursor(LoadCursor(NULL, IDC_APPSTARTING));
		break;
	case 1:
		ChangeClassCursors((LONG)IDC_ARROW);
		SetCursor(LoadCursor(NULL, IDC_ARROW));
		break;
	case 2:
		ChangeClassCursors((LONG)IDC_CROSS);
		SetCursor(LoadCursor(NULL, IDC_CROSS));
		break;
	case 3:
		ChangeClassCursors((LONG)IDC_IBEAM);
		SetCursor(LoadCursor(NULL, IDC_IBEAM));
		break;
	case 4:
		ChangeClassCursors((LONG)IDC_NO);
		SetCursor(LoadCursor(NULL, IDC_NO));
		break;
	case 5:
		ChangeClassCursors((LONG)IDC_SIZEALL);
		SetCursor(LoadCursor(NULL, IDC_SIZEALL));
		break;
	case 6:
		ChangeClassCursors((LONG)IDC_SIZENESW);
		SetCursor(LoadCursor(NULL, IDC_SIZENESW));
		break;
	case 7:
		ChangeClassCursors((LONG)IDC_SIZENS);
		SetCursor(LoadCursor(NULL, IDC_SIZENS));
		break;
	case 8:
		ChangeClassCursors((LONG)IDC_SIZENWSE);
		SetCursor(LoadCursor(NULL, IDC_SIZENWSE));
		break;
	case 9:
		ChangeClassCursors((LONG)IDC_SIZEWE);
		SetCursor(LoadCursor(NULL, IDC_SIZEWE));
		break;
	case 10:
		ChangeClassCursors((LONG)IDC_UPARROW);
		SetCursor(LoadCursor(NULL, IDC_UPARROW));
		break;
	case 11:
		ChangeClassCursors((LONG)IDC_WAIT);
		SetCursor(LoadCursor(NULL, IDC_WAIT));
		break;
	}
}

#endif /* MYSZ_H */