#include "Mysz.h"

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_CREATE:
		{
			// first group box
			hGroupPosition = CreateWindow("Button", "Pozycja kursora", WS_VISIBLE | WS_CHILD | BS_GROUPBOX, 5, 5, 330, 115, hWnd, NULL, NULL, NULL);
			hLabelX = CreateWindow("Static", "Wsprzdna X:", WS_VISIBLE | WS_CHILD, 20, 30, 100, 25, hWnd, NULL, NULL, NULL);
			hEditX = CreateWindow("Edit", "0", WS_VISIBLE | WS_CHILD | ES_CENTER | WS_BORDER, 110, 25, 80, 25, hWnd, NULL, NULL, NULL);
			hButtonSetCursor = CreateWindow("Button", "Ustaw pozycj kursora", WS_VISIBLE | WS_CHILD, 200, 25, 120, 25, hWnd, (HMENU)BT_SETCURSOR, NULL, NULL);
			hLabelY = CreateWindow("Static", "Wsprzdna Y:", WS_VISIBLE | WS_CHILD, 20, 65, 100, 25, hWnd, NULL, NULL, NULL);
			hEditY = CreateWindow("Edit", "0", WS_VISIBLE | WS_CHILD | ES_CENTER | WS_BORDER, 110, 60, 80, 25, hWnd, NULL, NULL, NULL);
			hButtonGetCursor = CreateWindow("Button", "Pobierz pozycj kursora", WS_VISIBLE | WS_CHILD, 200, 60, 120, 25, hWnd, (HMENU)BT_GETCURSOR, NULL, NULL);
			hCheckPos = CreateWindow("Button", "Odczytuj pozycj kursora w sposb cigy", WS_VISIBLE | WS_CHILD | BS_AUTOCHECKBOX, 50, 90, 260, 25, hWnd, (HMENU)CB_POS, NULL, NULL);

			ChangeControlFont(hGroupPosition);
			ChangeControlFont(hLabelX);
			ChangeControlFont(hLabelY);
			ChangeControlFont(hButtonSetCursor);
			ChangeControlFont(hEditX);
			ChangeControlFont(hEditY);
			ChangeControlFont(hButtonGetCursor);
			ChangeControlFont(hCheckPos);

			// second group box
			hGroupModifiers = CreateWindow("Button", "Modyfikacje kursora", WS_VISIBLE | WS_CHILD | BS_GROUPBOX, 5, 125, 330, 85, hWnd, NULL, NULL, NULL);
			hLabelChange = CreateWindow("Static", "Zmiana ksztatu kursora:", WS_VISIBLE | WS_CHILD, 20, 150, 150, 25, hWnd, NULL, NULL, NULL);
			// if combo box height will be to small drop down list will not appear
			// height should be set when all items to combo box list have been added
			// i used const size - code will be much simpler
			hComboModifiers = CreateWindowA("ComboBox", NULL, WS_VISIBLE | WS_CHILD | CBS_DROPDOWNLIST, 150, 147, 170, 220, hWnd, NULL, NULL, NULL);
			hButtonRestore = CreateWindow("Button", "Przywr domylny ksztat kursora systemowego", WS_VISIBLE | WS_CHILD, 20, 175, 300, 25, hWnd, (HMENU)BT_RESTORE, NULL, NULL);

			ChangeControlFont(hGroupModifiers);
			ChangeControlFont(hLabelChange);
			ChangeControlFont(hComboModifiers);
			ChangeControlFont(hButtonRestore);

			// add positions to combo box
			SendMessage(hComboModifiers, CB_RESETCONTENT, NULL, NULL);
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_APPSTARTING");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_ARROW");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_CROSS");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_IBEAM");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_NO");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_SIZEALL");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_SIZENESW");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_SIZENS");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_SIZENWSE");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_SIZEWE");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_UPARROW");
			SendMessage(hComboModifiers, CB_ADDSTRING, NULL, (LPARAM)"IDC_WAIT");

			SendMessage(hComboModifiers, CB_SETCURSEL, 1, NULL);	// select arrow for start

			// thirt group box
			hGroupOthers = CreateWindow("Button", "Inne", WS_VISIBLE | WS_CHILD | BS_GROUPBOX, 5, 215, 330, 85, hWnd, NULL, NULL, NULL);
			hCheckClip = CreateWindow("Button", "Przypnij kursor do okna", WS_VISIBLE | WS_CHILD | BS_AUTOCHECKBOX, 50, 235, 150, 25, hWnd, (HMENU)CB_CLIP, NULL, NULL);
			hCheckHide = CreateWindow("Button", "Ukryj kursor", WS_VISIBLE | WS_CHILD | BS_AUTOCHECKBOX, 200, 235, 100, 25, hWnd, (HMENU)CB_HIDE, NULL, NULL);
			hButtonWindow = CreateWindow("Button", "Pobierz tytu i numer uchwytu okna pod kursorem", WS_VISIBLE | WS_CHILD, 20, 265, 300, 25, hWnd, (HMENU)BT_WINDOW, NULL, NULL);

			ChangeControlFont(hGroupOthers);
			ChangeControlFont(hCheckClip);
			ChangeControlFont(hCheckHide);
			ChangeControlFont(hButtonWindow);

			// additional system menu position
			AppendMenu(GetSystemMenu(hWnd, false), MF_SEPARATOR, 0, NULL);
			AppendMenu(GetSystemMenu(hWnd, false), MF_STRING, 101, "O programie...");
		}
		break;
	case WM_SYSCOMMAND:
		{
			switch(wParam)
			{
			case 101:
				MessageBox(NULL, "Aplikacja demonstrujca podstawowe elementy obsugi myszy.\n\nAutor: Tomasz Dzieniak\nNa podstawie projektu Alicji Zwiewki z pniejszymi modyfikacjami Sz. P. dr Jacka Matulewskiego", "Informacja", MB_OK | MB_ICONASTERISK);
				break;
			}
		}
		break;
	case WM_COMMAND:
		{
			switch(wParam)
			{
			case BT_SETCURSOR:
				{
					GetWindowText(hEditX, temp, 1024);
					int x = atoi(temp);
					GetWindowText(hEditY, temp, 1024);
					int y = atoi(temp);

					SetCursorPos(x, y);
				}
				break;
			case BT_GETCURSOR:
				{
					POINT cursorPosition;
					GetCursorPos(&cursorPosition);

					sprintf_s(temp, 1024, "%d", cursorPosition.x);
					SetWindowText(hEditX, temp);

					sprintf_s(temp, 1024, "%d", cursorPosition.y);
					SetWindowText(hEditY, temp);
				}
				break;
			case BT_RESTORE:
				SetCursor(LoadCursor(NULL, IDC_ARROW));
				SendMessage(hComboModifiers, CB_SETCURSEL, 1, NULL);	// select concrete option in combo box
				break;
			case BT_WINDOW:
				{
					POINT cursorPosition;
					GetCursorPos(&cursorPosition);
					HWND hWindow = WindowFromPoint(cursorPosition);
					GetWindowText(hWindow, temp, 1024);

					char* temp_string = new char[1024];

					sprintf_s(temp_string, 1024, "Pod kursorem jest okno o tytule \"%s\" (uchwyt: %d)", temp, hWindow);
					MessageBox(NULL, temp_string, "Tytu i numer uchwytu okna pod kursorem", MB_OK | MB_ICONASTERISK);
					delete temp_string;
				}
				break;
			}
			if(HIWORD(wParam) == BN_CLICKED)
			{
				switch(LOWORD(wParam))
				{
				case CB_CLIP:
					{
						if(SendMessage(hCheckClip, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
						{
							RECT rcWindow;
							GetWindowRect(GetForegroundWindow(), &rcWindow);
							ClipCursor(&rcWindow);
						}
						else
							ClipCursor(NULL);
					}
					break;
				case CB_HIDE:
					if(SendMessage(hCheckHide, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
						ShowCursor(false);
					else
						ShowCursor(true);
					break;
				}
			}
			if(HIWORD(wParam) == CBN_SELCHANGE && lParam == (LPARAM)hComboModifiers)
			{
				MouseChange();
			}
		}
		break;
	case WM_WINDOWPOSCHANGED:
		{
			// Mouse is automaticaly unclipped when window is moved, minimalized...
			// Should to change the state of check box identifies mouse clipping to off
			SendMessage(hCheckClip, BM_SETCHECK, NULL, NULL);
		}
		break;
	case WM_NCMOUSEMOVE:
		{
			// Cursor automatically changes on hovering outside client area so it is necessary to change 
			// current selection in combo box on default (ofc when is not selected)
			if(SendMessage(hComboModifiers, CB_GETCURSEL, 1, NULL) != 1)
				SendMessage(hComboModifiers, CB_SETCURSEL, 1, NULL);

			// Removes Cursor Invisibility for case when focus on Hide Cursor Check Box has been lost while mouse pointer hovers outside client area
			if(SendMessage(hCheckHide, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
			{
				SendMessage(hCheckHide, BM_SETCHECK, NULL, NULL);
				ShowCursor(true);
			}
		}
		break;
	case WM_MOUSEMOVE:
		if(SendMessage(hCheckPos, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
		{
			POINT cursorPosition;
			GetCursorPos(&cursorPosition);

			sprintf_s(temp, 1024, "%d", cursorPosition.x);
			SetWindowText(hEditX, temp);

			sprintf_s(temp, 1024, "%d", cursorPosition.y);
			SetWindowText(hEditY, temp);				
		}
		break;
	case WM_SETCURSOR:
		break;
	case WM_DESTROY:
		delete temp;
		//  On the safe side - change cursor to arrow on quit and set to visible
		SetCursor(LoadCursor(NULL, IDC_ARROW));
		ShowCursor(true);
		PostQuitMessage(0);
		break;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, char* sCmd, int nShowCmd)
{
	WNDCLASSEX windowClass;
	ZeroMemory(&windowClass, sizeof(WNDCLASSEX));

	windowClass.cbSize = sizeof(WNDCLASSEX);
	windowClass.hInstance = hInstance;
	windowClass.lpfnWndProc = WndProc;
	windowClass.lpszClassName = "WinAPI_Mouse";
	windowClass.hbrBackground = (HBRUSH) COLOR_WINDOW;
	windowClass.hCursor = LoadCursor(hInstance, IDC_ARROW);;
	windowClass.hIcon = LoadIcon(hInstance, IDI_APPLICATION);

	RegisterClassEx(&windowClass);

	RECT rcObszarKlienta = { 0, 0, 340, 305 };
	AdjustWindowRect(&rcObszarKlienta, WS_POPUPKIND, NULL);

	HWND hWnd = CreateWindow("WinAPI_Mouse", "Funkcje WinAPI zwizane z mysz", WS_POPUPKIND, 
		CW_USEDEFAULT, CW_USEDEFAULT, 
		rcObszarKlienta.right-rcObszarKlienta.left, 
		rcObszarKlienta.bottom-rcObszarKlienta.top, 
		NULL, NULL, hInstance, NULL);

	ShowWindow(hWnd, 0x00000005L);	// SW_SHOW

	MSG mMsg;
	while(GetMessage(&mMsg, NULL, NULL, NULL))
	{
		TranslateMessage(&mMsg);
		DispatchMessage(&mMsg);
	}

	return static_cast<int>(mMsg.wParam);
}