#include "MessagesDLL.h"

void MyShowMessage(const char* Text)
{
	MessageBox(NULL, Text, "Biblioteka DLL", MB_OK);
}

 DLLExport void Test0()
{
	MyShowMessage("DLL: Test0");
}

DLLExport void Test1()
{
	MyShowMessage("DLL: Test1");
}

DLLExport void __stdcall Test2()
{
	MyShowMessage("DLL: Test2");
	FunkcjaWewnetrzna();
}

void FunkcjaWewnetrzna()
{
	MyShowMessage("DLL: FunkcjaWewnetrzna");
}

DLLExport int __stdcall Test3a(const char* Text)
{
	MyShowMessage("DLL: Test3a (funkcja pobierajca argument i zwracajca warto)");

	int dlugosc = strlen(Text);
	
	char* temp = new char[1024];
	sprintf_s(temp, sizeof(char)*1024,"DLL: Test3a, Argument: %s", Text);
	sprintf_s(temp, sizeof(char)*1024,"%s, dugo: %d", temp, dlugosc);

	MyShowMessage(temp);
	return dlugosc;
}
DLLExport const char* __stdcall Test3b(const char* Text)
{
	MyShowMessage("DLL: Test3b (funkcja pobierajca argument i zwracajca warto)");

	int dlugosc = strlen(Text);
	char* temp = new char[1024];
	sprintf_s(temp, sizeof(char)*1024,"DLL: Test3b, Argument: %s", Text);
	sprintf_s(temp, sizeof(char)*1024,"%s, dugo: %d", temp, dlugosc);

	MyShowMessage(temp);
	return Text;
}

DLLExport int __stdcall Test3c(int i)
{
	MyShowMessage("DLL: Test3c (funkcja pobierajca argument i zwracajca warto)");

	char* temp = new char[1024];
	sprintf_s(temp, sizeof(char)*1024,"DLL: Test3c, Argument: %d", i);

	MyShowMessage(temp);
	return i;
}

BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD uMsg, LPVOID lpvReserved)
{
	switch(uMsg)
	{
	case DLL_PROCESS_ATTACH:
		MyShowMessage("DLL: DllMain, Biblioteka zaadowana do procesu");
		break;
	case DLL_PROCESS_DETACH:
		MyShowMessage("DLL: DllMain, Biblioteka wyadowana z procesu");
		break;
	default:
		MyShowMessage("DLL: DllMain, Inny powd");
		break;
	}

	return 1;
}