#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#include <string>
 
#define DLLImport extern "C" __declspec(dllimport)

DLLImport void Test0();
DLLImport void Test1();
DLLImport void __stdcall Test2();
DLLImport int __stdcall Test3a(const char* Text);
DLLImport char* __stdcall Test3b(const char* Text);
DLLImport int __stdcall Test3c(int i);

HWND hButton;
enum BUTTON_IDS { ID_IMPORT = 1 };
 
HINSTANCE FindInstance(const char* windowClassName)
{
    HWND hwndApp = FindWindowA(NULL, windowClassName);
	return (HINSTANCE)GetWindowLong(hwndApp, GWL_HINSTANCE);
}
 
HWND ButtonFactory(const char* Caption, const char* windowClassName, HWND hWnd, BUTTON_IDS button_id, int X, int Y)
{
	
    HINSTANCE hInstance = FindInstance("simpleWindow");
 
    return CreateWindowEx(
        NULL,
        Caption,
        windowClassName,
        WS_CHILD | WS_VISIBLE,
        X, Y,
        350, 70,
        hWnd,
        (HMENU)button_id,
        hInstance,
        NULL
    );
}
 
LRESULT CALLBACK WndProcEvent(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
 
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmd, int nShowCmd)
{
    WNDCLASSEX classWindow;
    ZeroMemory(&classWindow, sizeof(classWindow));
    classWindow.cbSize = sizeof(classWindow);
    classWindow.hInstance = hInstance;
    classWindow.lpfnWndProc = WndProcEvent;
    classWindow.hbrBackground = (HBRUSH) COLOR_WINDOW;
    classWindow.hCursor = LoadCursor(hInstance, IDC_ARROW);
    classWindow.hIcon = LoadIcon(hInstance, IDI_APPLICATION);
	classWindow.hIconSm = LoadIcon(hInstance, IDI_APPLICATION);
    classWindow.lpszClassName = "importLib";
 
    RegisterClassEx(&classWindow);
 
    HWND hWnd = CreateWindowEx(
        NULL,
        "importLib",
        "Importowanie Statyczne",
		WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME & ~WS_MAXIMIZEBOX,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        420,
        160,
        (HWND)NULL,
        (HMENU)NULL,
        hInstance,
        NULL
        );
 
    ShowWindow(hWnd, nShowCmd);
 
    MSG msgMsg;
    while(GetMessage(&msgMsg, NULL, 0, 0))
    {
        TranslateMessage(&msgMsg);
        DispatchMessage(&msgMsg);
    }
 
    return static_cast<int>(msgMsg.wParam);
}
 
LRESULT CALLBACK WndProcEvent(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch(uMsg)
    {
    case WM_CREATE:
        hButton = ButtonFactory("Button", "Zaaduj bibliotek do pamici i uruchom funkcje", hWnd, ID_IMPORT, 30, 30);
        break;
    case WM_COMMAND:
        switch(wParam)
        {
        case ID_IMPORT:
            Test0();
			Test1();
			Test2();
			// Test 3a
			int wynik = Test3a("Przykadowy tekst");
			char* temp = new char[1024];
			sprintf_s(temp, sizeof(char)*1024, "Wynik: %d", wynik);
			MessageBox(NULL, temp, "Wynik", MB_OK);
			// Test 3b
			ZeroMemory(temp, sizeof(char)*1024);
			sprintf_s(temp, sizeof(char)*1024, Test3b("Kolejny przykadowy tekst"));
			char* temp2 = new char[1024];
			sprintf_s(temp2, sizeof(char)*1024, "Wynik: %s", temp);
			MessageBox(NULL, temp2, "Wynik", MB_OK);
			delete temp2;
			// Test 3c
			ZeroMemory(temp, sizeof(char)*1024);
			wynik = Test3c(32);
			sprintf_s(temp, sizeof(char)*1024, "Wynik: %d", wynik);
			MessageBox(NULL, temp, "Wynik", MB_OK);
			delete temp;
            break;
        }
        break;
    case WM_DESTROY:
        PostQuitMessage(0);
        break;
    }
 
    return DefWindowProc(hWnd, uMsg, wParam, lParam);
}